<?php

namespace App\Console\Commands;

use App\Services\Transactions\AutoCallAllocationService;
use Carbon\Carbon;
use Illuminate\Console\Command;
use Log;

class AutoCallAllocation extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'call:allocate';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'allocate unassigned calls to users every day';

    /**
     * Execute the console command.
     *
     * @return int
     */

    public $autoCallAllocationService;

    public function handle(AutoCallAllocationService $autoCallAllocationService)
    {
        Log::info('auto call allocation started : ' . Carbon::now());
        $autoCallAllocationService->allocateData();
        Log::info('auto call allocation end : ' . Carbon::now());
    }
}
