<?php

namespace App\Console\Commands;

use App\Services\Transactions\AutoCallAllocationFestiveService;
use Carbon\Carbon;
use Illuminate\Console\Command;
use Log;

class AutoCallAllocationFestiveCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'festive:allocate';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'allocate unassigned calls to users festival day';

    /**
     * Execute the console command.
     *
     * @return int
     */

    public $autoCallAllocationFestiveService;

    public function handle(AutoCallAllocationFestiveService $autoCallAllocationFestiveService)
    {
        Log::info('auto call allocation started for agents : ' . Carbon::now());
        $autoCallAllocationFestiveService->allocateData(1);
        Log::info('auto call allocation end for agents : ' . Carbon::now());
        Log::info('auto call allocation started for BM : ' . Carbon::now());
        $autoCallAllocationFestiveService->allocateData(2);
        Log::info('auto call allocation end for BM : ' . Carbon::now());
    }
}
