<?php

namespace App\Exports;

use Log;
use PhpOffice\PhpSpreadsheet\Reader\Exception;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xls;
use Carbon\Carbon;

class AgentwiseCallsReportExcel
{

    public $excelEntities;

    public function __construct(ExcelEntities $excelEntities)
    {
        $this->excelEntities = $excelEntities;
    }

    public function exportExcel($request, $data)
    {
        ob_start();
        ini_set('max_execution_time', 0);
        ini_set('memory_limit', '4000M');

        try {

            $spreadSheet = new Spreadsheet();

            $sheet = $spreadSheet->getActiveSheet();

            $bold = $this->excelEntities->styleBold();
            $heading = $this->excelEntities->styleHeading1();

            $sheet->setCellValue('A1', 'Date Range : ' . Carbon::parse($request->fromDate)->format('d/m/Y') . ' to ' . Carbon::parse($request->toDate)->format('d/m/Y'));
            $sheet->setCellValue('A2', 'Branch : ' . $request->branchLabel);
            $sheet->setCellValue('A3', 'Agent : ' . $request->agentLabel);

            $sheet->setCellValue('A4', 'Branch');
            $sheet->setCellValue('B4', 'Agent');
            $sheet->setCellValue('C4', 'Designation');
            $sheet->setCellValue('D4', 'Allocated Calls');
            $sheet->setCellValue('E4', 'Dialled Calls');
            $sheet->setCellValue('F4', 'Connected Calls');
            $sheet->setCellValue('G4', 'Not Connected Calls');

            $sheet->getStyle('A1')->applyFromArray($heading);
            $sheet->getStyle('A2')->applyFromArray($heading);
            $sheet->getStyle('A3')->applyFromArray($heading);
            $sheet->getStyle('A4')->applyFromArray($heading);

            $sheet->getStyle('A4:G4')->applyFromArray($bold);

            $rows = 5;

            foreach ($data as $key => $val) {

                $sheet->setCellValue('A' . $rows, $val->branchName);
                $sheet->setCellValue('B' . $rows, $val->agentName);
                $sheet->setCellValue('C' . $rows, $val->designation);
                $sheet->setCellValue('D' . $rows, $val->allocatedCalls);
                $sheet->setCellValue('E' . $rows, $val->dialledCalls);
                $sheet->setCellValue('F' . $rows, $val->connectedCalls);
                $sheet->setCellValue('G' . $rows, $val->notConnectedCalls);
                $rows++;
            }

            $Excel_writer = new Xls($spreadSheet);

            header('Content-Type: application/vnd.ms-excel');
            header('Content-Disposition: attachment;filename="agentwisecalls-report.xls"');
            header('Cache-Control: max-age=0');
            ob_end_clean();
            $Excel_writer->save('php://output');
            exit();
        } catch (Exception $e) {
            Log::info('nocalls report export error : ' . $e);
        }
    }
}
