<?php

namespace App\Exports;

use Log;
use PhpOffice\PhpSpreadsheet\Reader\Exception;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xls;
use Carbon\Carbon;

class DashboardDetailedReportExport
{

    public $excelEntities;

    public function __construct(ExcelEntities $excelEntities)
    {
        $this->excelEntities = $excelEntities;
    }

    public function exportAgents($request, $data)
    {

        ob_start();
        ini_set('max_execution_time', 0);
        ini_set('memory_limit', '4000M');

        try {

            $spreadSheet = new Spreadsheet();
            $sheet = $spreadSheet->getActiveSheet();
            $sheet->setTitle($request->fieldType);

            $Excel_writer = new Xls($spreadSheet);

            $bold = $this->excelEntities->styleBold();
            $heading = $this->excelEntities->styleHeading1();

            $sheet->setCellValue('A1', 'Agent Name');
            $sheet->setCellValue('B1', 'Branch Name');
            $sheet->getStyle('A1:B1')->applyFromArray($bold);

            $rows = 2;

            foreach ($data as $key => $val) {
                $sheet->setCellValue('A' . $rows, isset($val->agentName) ? $val->agentName : '');
                $sheet->setCellValue('B' . $rows, isset($val->branchName) ? $val->branchName : '');
                $rows++;
            }

            header('Content-Type: application/vnd.ms-excel');
            header('Content-Disposition: attachment;filename="agents.xls"');
            header('Cache-Control: max-age=0');
            ob_end_clean();
            $Excel_writer->save('php://output');
            exit();
        } catch (Exception $e) {

            Log::info('dashboard report export error : ' . $e);
        }
    }

    public function exportBranches($request, $data)
    {

        ob_start();
        ini_set('max_execution_time', 0);
        ini_set('memory_limit', '4000M');

        try {

            $spreadSheet = new Spreadsheet();
            $sheet = $spreadSheet->getActiveSheet();
            $sheet->setTitle($request->fieldType);

            $Excel_writer = new Xls($spreadSheet);

            $bold = $this->excelEntities->styleBold();
            $heading = $this->excelEntities->styleHeading1();


            $sheet->setCellValue('A1', 'Branch Name');
            $sheet->getStyle('A1')->applyFromArray($heading);

            $rows = 2;

            foreach ($data as $key => $val) {
                $sheet->setCellValue('A' . $rows, isset($val->name) ? $val->name : '');
                $rows++;
            }

            header('Content-Type: application/vnd.ms-excel');
            header('Content-Disposition: attachment;filename="branches.xls"');
            header('Cache-Control: max-age=0');
            ob_end_clean();
            $Excel_writer->save('php://output');
            exit();
        } catch (Exception $e) {

            Log::info('dashboard report export error : ' . $e);
        }
    }

    public function exportCallHistory($request, $data)
    {

        ob_start();
        ini_set('max_execution_time', 0);
        ini_set('memory_limit', '4000M');

        try {

            $spreadSheet = new Spreadsheet();
            $sheet = $spreadSheet->getActiveSheet();
            $sheet->setTitle($request->fieldType);
            $this->callHistoryGenerate($sheet, $request, $data);

            $Excel_writer = new Xls($spreadSheet);

            header('Content-Type: application/vnd.ms-excel');
            header('Content-Disposition: attachment;filename="call-details-report.xls"');
            header('Cache-Control: max-age=0');
            ob_end_clean();
            $Excel_writer->save('php://output');
            exit();
        } catch (Exception $e) {

            Log::info('dashboard report export error : ' . $e);
        }
    }

    public function exportCallHistoryTwoSheet($request, $data, $data1)
    {

        ob_start();
        ini_set('max_execution_time', 0);
        ini_set('memory_limit', '4000M');

        try {

            $spreadSheet = new Spreadsheet();
            $sheet = $spreadSheet->getActiveSheet();
            $sheet->setTitle($request->title);
            $this->callHistoryGenerate($sheet, $request, $data);

            $sheet2 = $spreadSheet->createSheet();
            $sheet2->setTitle($request->title1);
            $this->callHistoryGenerate($sheet2, $request, $data1);

            $Excel_writer = new Xls($spreadSheet);

            header('Content-Type: application/vnd.ms-excel');
            header('Content-Disposition: attachment;filename="call-details-report.xls"');
            header('Cache-Control: max-age=0');
            ob_end_clean();
            $Excel_writer->save('php://output');
            exit();
        } catch (Exception $e) {

            Log::info('dashboard report export error : ' . $e);
        }
    }

    public function exportSalesAndEnquiry($request, $data, $data1)
    {

        ob_start();
        ini_set('max_execution_time', 0);
        ini_set('memory_limit', '4000M');

        try {

            $spreadSheet = new Spreadsheet();
            $sheet = $spreadSheet->getActiveSheet();
            $sheet->setTitle($request->title);
            $this->salesSheetGenerate($sheet, $request, $data);

            $sheet2 = $spreadSheet->createSheet();
            $sheet2->setTitle($request->title1);
            $this->salesSheetGenerate($sheet2, $request, $data1);

            $Excel_writer = new Xls($spreadSheet);

            header('Content-Type: application/vnd.ms-excel');
            header('Content-Disposition: attachment;filename="' . $request->title . '-report.xls"');
            header('Cache-Control: max-age=0');
            ob_end_clean();
            $Excel_writer->save('php://output');
            exit();
        } catch (Exception $e) {

            Log::info('dashboard sales report export error : ' . $e);
        }
    }

    function salesSheetGenerate($sheet, $request, $data)
    {

        $bold = $this->excelEntities->styleBold();
        $heading = $this->excelEntities->styleHeading1();

        $sheet->setCellValue('A1', 'Date Range : ' . Carbon::parse($request->fromDate)->format('d/m/Y') . ' to ' . Carbon::parse($request->toDate)->format('d/m/Y'));
        $sheet->setCellValue('A2', 'Cluster : ' . $request->clusterLabel);
        $sheet->setCellValue('A3', 'Branch : ' . $request->branchLabel);
        $sheet->setCellValue('A4', 'Agent : ' . $request->agentLabel);

        $sheet->setCellValue('A5', 'Branch Name');
        $sheet->setCellValue('B5', 'Agent Name');
        $sheet->setCellValue('C5', 'Date');
        $sheet->setCellValue('D5', 'Cutomer Name');
        $sheet->setCellValue('E5', 'Mobile');
        $sheet->setCellValue('F5', 'Product');
        $sheet->setCellValue('G5', 'Description');

        $sheet->getStyle('A1')->applyFromArray($heading);
        $sheet->getStyle('A2')->applyFromArray($heading);
        $sheet->getStyle('A3')->applyFromArray($heading);
        $sheet->getStyle('A4')->applyFromArray($heading);
        $sheet->getStyle('A5')->applyFromArray($heading);

        $sheet->getStyle('A5:G5')->applyFromArray($bold);

        $rows = 6;

        foreach ($data as $key => $val) {

            $sheet->setCellValue('A' . $rows, isset($val->branchName) ? $val->branchName : '');
            $sheet->setCellValue('B' . $rows, isset($val->agentName) ? $val->agentName : '');
            $sheet->setCellValue('C' . $rows, isset($val->date) ? AppDateFormat($val->date) : '');
            $sheet->setCellValue('D' . $rows, isset($val->customer_name) ? $val->customer_name : '');
            $sheet->setCellValue('E' . $rows, isset($val->mobile) ? $val->mobile : '');
            $sheet->setCellValue('F' . $rows, isset($val->product) ? $val->product : '');
            $sheet->setCellValue('G' . $rows, isset($val->description) ? $val->description : '');
            $rows++;
        }
    }

    function callHistoryGenerate($sheet, $request, $data)
    {

        $bold = $this->excelEntities->styleBold();
        $heading = $this->excelEntities->styleHeading1();

        $sheet->setCellValue('A1', 'Date Range : ' . Carbon::parse($request->fromDate)->format('d/m/Y') . ' to ' . Carbon::parse($request->toDate)->format('d/m/Y'));
        $sheet->setCellValue('A2', 'Cluster : ' . $request->clusterLabel);
        $sheet->setCellValue('A3', 'Branch : ' . $request->branchLabel);
        $sheet->setCellValue('A4', 'Agent : ' . $request->agentLabel);

        $sheet->setCellValue('A5', 'Branch Name');
        $sheet->setCellValue('B5', 'Agent Name');
        $sheet->setCellValue('C5', 'Call Date & Time');
        $sheet->setCellValue('D5', 'Cutomer Name');
        $sheet->setCellValue('E5', 'Mobile');
        $sheet->setCellValue('F5', 'Invoice Date');
        $sheet->setCellValue('G5', 'Description');

        $sheet->getStyle('A1')->applyFromArray($heading);
        $sheet->getStyle('A2')->applyFromArray($heading);
        $sheet->getStyle('A3')->applyFromArray($heading);
        $sheet->getStyle('A4')->applyFromArray($heading);
        $sheet->getStyle('A5')->applyFromArray($heading);

        $sheet->getStyle('A5:G5')->applyFromArray($bold);

        $rows = 6;

        foreach ($data as $key => $val) {

            $sheet->setCellValue('A' . $rows, isset($val->branchName) ? $val->branchName : '');
            $sheet->setCellValue('B' . $rows, isset($val->agentName) ? $val->agentName : '');
            $sheet->setCellValue('C' . $rows, isset($val->created_at) ? AppDateTimeFormat($val->created_at) : '');
            $sheet->setCellValue('D' . $rows, isset($val->customer_name) ? $val->customer_name : '');
            $sheet->setCellValue('E' . $rows, isset($val->mobile_number) ? $val->mobile_number : '');
            $sheet->setCellValue('F' . $rows, isset($val->invoice_date) ? $val->invoice_date : '');
            $sheet->setCellValue('G' . $rows, isset($val->description) ? $val->description : '');
            $rows++;
        }
    }
}
