<?php

namespace App\Exports;

use Log;
use PhpOffice\PhpSpreadsheet\Reader\Exception;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xls;
use Carbon\Carbon;

class EnquiryExcelExport
{

    public $excelEntities;

    public function __construct(ExcelEntities $excelEntities)
    {
        $this->excelEntities = $excelEntities;
    }

    public function exportExcel($request, $data)
    {
        ob_start();
        ini_set('max_execution_time', 0);
        ini_set('memory_limit', '4000M');

        try {

            $spreadSheet = new Spreadsheet();

            $sheet = $spreadSheet->getActiveSheet();

            $bold = $this->excelEntities->styleBold();
            $heading = $this->excelEntities->styleHeading1();

            $sheet->setCellValue('A1', 'Date Range : ' . Carbon::parse($request->fromDate)->format('d/m/Y') . ' to ' . Carbon::parse($request->toDate)->format('d/m/Y'));
            $sheet->setCellValue('A2', 'Cluster : ' . $request->clusterLabel);
            $sheet->setCellValue('A3', 'Branch : ' . $request->branchLabel);

            $sheet->setCellValue('A4', 'Cluster');
            $sheet->setCellValue('B4', 'Branch');
            $sheet->setCellValue('C4', 'Date');
            $sheet->setCellValue('D4', 'Ref No');
            $sheet->setCellValue('E4', 'Customer Name');
            $sheet->setCellValue('F4', 'Mobile');
            $sheet->setCellValue('G4', 'Product');
            $sheet->setCellValue('H4', 'Description');
            $sheet->setCellValue('I4', 'Followup Date');
            $sheet->setCellValue('J4', 'Order Source');
            $sheet->setCellValue('K4', 'Sales Emp');
            $sheet->setCellValue('L4', 'User Code');
            $sheet->setCellValue('M4', 'Category');
            $sheet->setCellValue('N4', 'Doc Status');
            $sheet->setCellValue('O4', 'Enq Reason');
            $sheet->setCellValue('P4', 'Remarks');
            $sheet->setCellValue('Q4', 'Designation');
            $sheet->setCellValue('R4', 'Salesman Mobile');
            $sheet->setCellValue('S4', 'Read Status Remarks');
            $sheet->setCellValue('T4', 'Read Status');
            $sheet->setCellValue('U4', 'Status');

            $sheet->getStyle('A1')->applyFromArray($heading);
            $sheet->getStyle('A2')->applyFromArray($heading);
            $sheet->getStyle('A3')->applyFromArray($heading);

            $sheet->getStyle('A4:U4')->applyFromArray($bold);

            $rows = 5;

            foreach ($data as $key => $val) {

                $sheet->setCellValue('A' . $rows, $val->clusterName);
                $sheet->setCellValue('B' . $rows, $val->branchName);
                $sheet->setCellValue('C' . $rows, $val->date);
                $sheet->setCellValue('D' . $rows, $val->sap_ref_id);
                $sheet->setCellValue('E' . $rows, $val->customer_name);
                $sheet->setCellValue('F' . $rows, $val->mobile);
                $sheet->setCellValue('G' . $rows, $val->product);
                $sheet->setCellValue('H' . $rows, $val->description);
                $sheet->setCellValue('I' . $rows, $val->followup_date);
                $sheet->setCellValue('J' . $rows, $val->order_source);
                $sheet->setCellValue('K' . $rows, $val->sale_employee);
                $sheet->setCellValue('L' . $rows, $val->user_code_id);
                $sheet->setCellValue('M' . $rows, $val->category);
                $sheet->setCellValue('N' . $rows, $val->doc_status);
                $sheet->setCellValue('O' . $rows, $val->enquiry_reason);
                $sheet->setCellValue('P' . $rows, $val->remarks);
                $sheet->setCellValue('Q' . $rows, $val->designation);
                $sheet->setCellValue('R' . $rows, $val->salesman_mobile);
                $sheet->setCellValue('S' . $rows, $val->read_status_remarks);
                $sheet->setCellValue('T' . $rows, $val->readStatus);
                $sheet->setCellValue('U' . $rows, $val->leadStatus);
                $rows++;
            }

            $Excel_writer = new Xls($spreadSheet);

            header('Content-Type: application/vnd.ms-excel');
            header('Content-Disposition: attachment;filename="enquiry-report.xls"');
            header('Cache-Control: max-age=0');
            ob_end_clean();
            $Excel_writer->save('php://output');
            exit();
        } catch (Exception $e) {
            Log::info('enquiry report export error : ' . $e);
        }
    }

}
