<?php

namespace App\Exports;

use Log;
use PhpOffice\PhpSpreadsheet\Reader\Exception;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
// use PhpOffice\PhpSpreadsheet\Writer\Xls;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use Carbon\Carbon;

class JustDialReportExport
{

    public $excelEntities;

    public function __construct(ExcelEntities $excelEntities)
    {
        $this->excelEntities = $excelEntities;
    }

    public function exportExcel($request, $data)
    {

        ob_start();
        ini_set('max_execution_time', 0);
        ini_set('memory_limit', '4000M');

        try {

            $spreadSheet = new Spreadsheet();

            $sheet = $spreadSheet->getActiveSheet();

            $bold = $this->excelEntities->styleBold();
            $heading = $this->excelEntities->styleHeading1();

            $sheet->setCellValue('A1', 'Date Range : ' . Carbon::parse($request->fromDate)->format('d/m/Y') . ' to ' . Carbon::parse($request->toDate)->format('d/m/Y'));
            $sheet->setCellValue('A2', 'Cluster : ' . $request->clusterLabel);
            $sheet->setCellValue('A3', 'Branch : ' . $request->branchLabel);

            $sheet->setCellValue('A4', 'Cluster');
            $sheet->setCellValue('B4', 'Branch');
            $sheet->setCellValue('C4', 'Date');
            $sheet->setCellValue('D4', 'Name');
            $sheet->setCellValue('E4', 'Mobile');
            $sheet->setCellValue('F4', 'Email');
            $sheet->setCellValue('G4', 'Category');
            $sheet->setCellValue('H4', 'City');
            $sheet->setCellValue('I4', 'Area');
            $sheet->setCellValue('J4', 'Branch Area');
            $sheet->setCellValue('K4', 'Remarks');
            $sheet->setCellValue('L4', 'Status');
            $sheet->setCellValue('M4', 'Read Status');

            $sheet->getStyle('A1')->applyFromArray($heading);
            $sheet->getStyle('A2')->applyFromArray($heading);
            $sheet->getStyle('A3')->applyFromArray($heading);

            $sheet->getStyle('A4:M4')->applyFromArray($bold);

            $rows = 5;

            foreach ($data as $key => $val) {

                $sheet->setCellValue('A' . $rows, $val->clusterName);
                $sheet->setCellValue('B' . $rows, $val->branchName);
                $sheet->setCellValue('C' . $rows, $val->date);
                $sheet->setCellValue('D' . $rows, $val->name);
                $sheet->setCellValue('E' . $rows, $val->mobile);
                $sheet->setCellValue('F' . $rows, $val->email);
                $sheet->setCellValue('G' . $rows, $val->category);
                $sheet->setCellValue('H' . $rows, $val->city);
                $sheet->setCellValue('I' . $rows, $val->area);
                $sheet->setCellValue('J' . $rows, $val->brancharea);
                $sheet->setCellValue('K' . $rows, $val->remarks);
                $sheet->setCellValue('L' . $rows, $val->leadStatus);
                $sheet->setCellValue('M' . $rows, $val->readStatus);
                $rows++;
            }

            // $Excel_writer = new Xls($spreadSheet);
            $Excel_writer = new Xlsx($spreadSheet);

            // header('Content-Type: application/vnd.ms-excel');
            // header('Content-Disposition: attachment;filename="justdial-report.xlsx"');
            header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
            header('Content-Disposition: attachment;filename="justdial-report.xlsx"');
            header('Cache-Control: max-age=0');
            ob_end_clean();
            $Excel_writer->save('php://output');
            exit();
        } catch (Exception $e) {
            Log::info('just dial report export error : ' . $e);
        }
    }
}
