<?php

namespace App\Exports;

use Log;
use PhpOffice\PhpSpreadsheet\Reader\Exception;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xls;
use Carbon\Carbon;

class PendingCallsExport
{

    public $excelEntities;

    public function __construct(ExcelEntities $excelEntities)
    {
        $this->excelEntities = $excelEntities;
    }

    public function exportExcel($request, $data)
    {
        ob_start();
        ini_set('max_execution_time', 0);
        ini_set('memory_limit', '4000M');

        try {

            $spreadSheet = new Spreadsheet();

            $sheet = $spreadSheet->getActiveSheet();

            $bold = $this->excelEntities->styleBold();
            $heading = $this->excelEntities->styleHeading1();

            $sheet->setCellValue('A1', 'Customer Name');
            $sheet->setCellValue('B1', 'Mobile');
            $sheet->setCellValue('C1', 'Invoice Date');
            $sheet->setCellValue('D1', 'Description');

            $sheet->getStyle('A1:D1')->applyFromArray($bold);

            $rows = 2;

            foreach ($data as $key => $val) {

                $sheet->setCellValue('A' . $rows, $val->customer_name);
                $sheet->setCellValue('B' . $rows, $val->mobile_number);
                $sheet->setCellValue('C' . $rows, AppDateFormat($val->invoice_date));
                $sheet->setCellValue('D' . $rows, $val->description);
                $rows++;
            }

            $Excel_writer = new Xls($spreadSheet);

            header('Content-Type: application/vnd.ms-excel');
            header('Content-Disposition: attachment;filename="pending-calls.xls"');
            header('Cache-Control: max-age=0');
            ob_end_clean();
            $Excel_writer->save('php://output');
            exit();
        } catch (Exception $e) {
            Log::info('pending calls report export error : ' . $e);
        }
    }
}
