<?php

namespace App\Exports;

use PhpOffice\PhpSpreadsheet\Reader\Exception;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xls;
use Log;

class ProgramwiseReportExport
{

    public $excelEntities;

    public function __construct(ExcelEntities $excelEntities)
    {
        $this->excelEntities = $excelEntities;
    }

    public function exportExcel($data)
    {

        ob_start();

        ini_set('max_execution_time', 0);
        ini_set('memory_limit', '4000M');

        try {

            $spreadSheet = new Spreadsheet();

            $sheet = $spreadSheet->getActiveSheet();

            $bold = $this->excelEntities->styleBold();
            $heading1 = $this->excelEntities->styleHeading1();
            $heading2 = $this->excelEntities->styleHeading2();

            $sheet->setCellValue('A1', 'Questions & Answers');
            $sheet->setCellValue('B1', 'Feedback');
            $sheet->setCellValue('C1', 'Percentage');

            $sheet->getStyle('A1')->applyFromArray($bold);
            $sheet->getStyle('B1')->applyFromArray($bold);
            $sheet->getStyle('C1')->applyFromArray($bold);


            $rows = 2;

            foreach ($data as $key => $val) {

                //programs loop
                $sheet->setCellValue('A' . $rows, removeHtmlTags($val->programName));
                $sheet->getStyle('A' . $rows)->applyFromArray($heading1);
                $sheet->setCellValue('B' . $rows, $val->feedbackCount);
                $rows++;

                if ($val->questions && count($val->questions) > 0) {
                    //questions
                    foreach ($val->questions as $question) {
                        $sheet->setCellValue('A' . $rows, removeHtmlTags($question->label));
                        $sheet->getStyle('A' . $rows)->applyFromArray($heading2);
                        $rows++;
                        //amswers
                        foreach ($question->answers as $answer) {
                            $sheet->setCellValue('A' . $rows, removeHtmlTags($answer->label));
                            $sheet->setCellValue('B' . $rows, $answer->count);
                            $sheet->setCellValue('C' . $rows, $answer->percentage);
                            $rows++;
                        }
                        $rows++;
                    }

                }

                $rows++;
                $rows++;

            }

            $Excel_writer = new Xls($spreadSheet);

            header('Content-Type: application/vnd.ms-excel');
            header('Content-Disposition: attachment;filename="programwise-report.xls"');
            header('Cache-Control: max-age=0');
            ob_end_clean();
            $Excel_writer->save('php://output');
            exit();

        } catch (Exception $e) {

            Log::info('Programwise report export error : '. $e);

        }

    }
}
