<?php

namespace App\Exports;

use Log;
use PhpOffice\PhpSpreadsheet\Reader\Exception;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xls;
use Carbon\Carbon;

class SalesReportExport
{

    public $excelEntities;

    public function __construct(ExcelEntities $excelEntities)
    {
        $this->excelEntities = $excelEntities;
    }

    public function exportExcel($request, $data)
    {
        ob_start();
        ini_set('max_execution_time', 0);
        ini_set('memory_limit', '4000M');

        try {

            $spreadSheet = new Spreadsheet();

            $sheet = $spreadSheet->getActiveSheet();

            $bold = $this->excelEntities->styleBold();
            $heading = $this->excelEntities->styleHeading1();

            $sheet->setCellValue('A1', 'Date Range : ' . Carbon::parse($request->fromDate)->format('d/m/Y') . ' to ' . Carbon::parse($request->toDate)->format('d/m/Y'));
            $sheet->setCellValue('A2', 'Cluster : ' . $request->clusterLabel);
            $sheet->setCellValue('A3', 'Branch : ' . $request->branchLabel);

            $sheet->setCellValue('A4', 'Cluster');
            $sheet->setCellValue('B4', 'Branch');
            $sheet->setCellValue('C4', 'Invoice Date');
            $sheet->setCellValue('D4', 'Order Ref No');
            $sheet->setCellValue('E4', 'Customer Name');
            $sheet->setCellValue('F4', 'Mobile');
            $sheet->setCellValue('G4', 'Product');
            $sheet->setCellValue('H4', 'Description');
            $sheet->setCellValue('I4', 'Amount');
            $sheet->setCellValue('J4', 'Followup Date');
            $sheet->setCellValue('K4', 'Order Source');
            $sheet->setCellValue('L4', 'Sales Emp');
            $sheet->setCellValue('M4', 'User Code');
            $sheet->setCellValue('N4', 'Category');
            $sheet->setCellValue('O4', 'Doc Status');
            $sheet->setCellValue('P4', 'Enq Reason');
            $sheet->setCellValue('Q4', 'Remarks');
            $sheet->setCellValue('R4', 'Designation');
            $sheet->setCellValue('S4', 'Salesman Mobile');

            $sheet->getStyle('A1')->applyFromArray($heading);
            $sheet->getStyle('A2')->applyFromArray($heading);
            $sheet->getStyle('A3')->applyFromArray($heading);

            $sheet->getStyle('A4:S4')->applyFromArray($bold);

            $rows = 5;

            foreach ($data as $key => $val) {

                $sheet->setCellValue('A' . $rows, $val->clusterName);
                $sheet->setCellValue('B' . $rows, $val->branchName);
                $sheet->setCellValue('C' . $rows, $val->invoice_date);
                $sheet->setCellValue('D' . $rows, $val->sap_ref_id);
                $sheet->setCellValue('E' . $rows, $val->customer_name);
                $sheet->setCellValue('F' . $rows, $val->mobile);
                $sheet->setCellValue('G' . $rows, $val->product);
                $sheet->setCellValue('H' . $rows, $val->description);
                $sheet->setCellValue('I' . $rows, $val->amount);
                $sheet->setCellValue('J' . $rows, $val->followup_date);
                $sheet->setCellValue('K' . $rows, $val->order_source);
                $sheet->setCellValue('L' . $rows, $val->sale_employee);
                $sheet->setCellValue('M' . $rows, $val->user_code_id);
                $sheet->setCellValue('N' . $rows, $val->category);
                $sheet->setCellValue('O' . $rows, $val->doc_status);
                $sheet->setCellValue('P' . $rows, $val->enquiry_reason);
                $sheet->setCellValue('Q' . $rows, $val->remarks);
                $sheet->setCellValue('R' . $rows, $val->designation);
                $sheet->setCellValue('S' . $rows, $val->salesman_mobile);
                $rows++;
            }

            $Excel_writer = new Xls($spreadSheet);

            header('Content-Type: application/vnd.ms-excel');
            header('Content-Disposition: attachment;filename="sales-report.xls"');
            header('Cache-Control: max-age=0');
            ob_end_clean();
            $Excel_writer->save('php://output');
            exit();
        } catch (Exception $e) {
            Log::info('Sales report export error : ' . $e);
        }
    }

}
