<?php

namespace App\Exports;

use Log;
use PhpOffice\PhpSpreadsheet\Reader\Exception;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xls;
use Carbon\Carbon;

class TicketsReportExcel
{

    public $excelEntities;

    public function __construct(ExcelEntities $excelEntities)
    {
        $this->excelEntities = $excelEntities;
    }

    public function exportExcel($request, $data)
    {
        $groupedData = $data->groupBy('status');
        // dd($groupedData);

        ob_start();
        ini_set('max_execution_time', 0);
        ini_set('memory_limit', '4000M');

        try {

            $spreadSheet = new Spreadsheet();
            $bold = $this->excelEntities->styleBold();
            $heading = $this->excelEntities->styleHeading1();
            $firstSheet = true;

            $ticketStatus = array(
                0 => 'Inactive',
                1 => 'Active',
                2 => 'WIP',
                3 => 'Closed',
                4 => 'Draft'
            );

            foreach ($groupedData as $key => $gData) {
                // echo $ticketStatus[$key]; exit;
                if ($firstSheet) {
                    $sheet = $spreadSheet->getActiveSheet();
                    $firstSheet = false;
                } else {
                    $sheet = $spreadSheet->createSheet();
                }
                $workbookName = $ticketStatus[$key] ? $ticketStatus[$key] : 'NA';
                $sheet->setTitle($workbookName);
                $spreadSheet->setActiveSheetIndexByName($workbookName);

                $sheet->setCellValue('A1', 'Date Range : ' . Carbon::parse($request->fromDate)->format('d/m/Y') . ' to ' . Carbon::parse($request->toDate)->format('d/m/Y'));
                // $sheet->setCellValue('A2', 'Cluster : ' . $request->clusterLabel);
                // $sheet->setCellValue('A3', 'Branch : ' . $request->branchLabel);
                // $sheet->setCellValue('A4', 'Agent : ' . $request->agentLabel);

                $sheet->setCellValue('A3', 'Ticket No');
                $sheet->setCellValue('B3', 'Branch');
                $sheet->setCellValue('C3', 'Name');
                $sheet->setCellValue('D3', 'Mobile Number');
                $sheet->setCellValue('E3', 'Secondary Mobile Number');
                $sheet->setCellValue('F3', 'Comment');
                $sheet->setCellValue('G3', 'Category');
                $sheet->setCellValue('H3', 'Expected Date');
                $sheet->setCellValue('I3', 'Date Created');
                $sheet->setCellValue('J3', 'Created By');
                $sheet->setCellValue('K3', 'Assigned To');
                $sheet->setCellValue('L3', 'File');
                $sheet->setCellValue('M3', 'Email');
                $sheet->setCellValue('N3', 'Location');
                $sheet->setCellValue('O3', 'Product Enquiry');
                $sheet->setCellValue('P3', 'Department');
                $sheet->setCellValue('Q3', 'Ticket Source');
                $sheet->setCellValue('R3', 'Ticket Type');
                $sheet->setCellValue('S3', 'Priority');
                $sheet->setCellValue('T3', 'Expected Price');
                $sheet->setCellValue('U3', 'Offer Price');
                $sheet->setCellValue('V3', 'Address');
                $sheet->setCellValue('W3', 'Status');
                $sheet->setCellValue('X3', 'Read Status');
                $sheet->setCellValue('Y3', 'Update Comments');
                $sheet->setCellValue('Z3', 'Lead Status');

                $sheet->getStyle('A1')->applyFromArray($heading);
                // $sheet->getStyle('A2')->applyFromArray($heading);
                // $sheet->getStyle('A3')->applyFromArray($heading);
                // $sheet->getStyle('A4')->applyFromArray($heading);

                $sheet->getStyle('A3:Z3')->applyFromArray($bold);

                $rows = 4;

                foreach ($gData as $val) {

                    $customerName = preg_replace('/[^\x20-\x7E]/', '', $val->customer_name);

                    $sheet->setCellValue('A' . $rows, $val->ticket_no);
                    $sheet->setCellValue('B' . $rows, $val->branchName);
                    $sheet->setCellValue('C' . $rows, $customerName);
                    $sheet->setCellValue('D' . $rows, $val->mobile);
                    $sheet->setCellValue('E' . $rows, $val->secondary_mobile);
                    $sheet->setCellValue('F' . $rows, $val->wrapText);
                    $sheet->setCellValue('G' . $rows, $val->ticketCategory);
                    $sheet->setCellValue('H' . $rows, $val->expectedDate);
                    $sheet->setCellValue('I' . $rows, $val->formattedCreatedAt);
                    $sheet->setCellValue('J' . $rows, $val->createdUser);
                    $sheet->setCellValue('K' . $rows, $val->assignedUser . ' (' . $val->agentDesignation . ')'. ' (' . $val->agentClass . ')');
                    $sheet->setCellValue('L' . $rows, $val->downloadUrl);
                    $sheet->setCellValue('M' . $rows, $val->email);
                    $sheet->setCellValue('N' . $rows, $val->location);
                    $sheet->setCellValue('O' . $rows, $val->productName . ' (' . $val->barndName . ')');
                    $sheet->setCellValue('P' . $rows, $val->deptName);
                    $sheet->setCellValue('Q' . $rows, $val->sourceName);
                    $sheet->setCellValue('R' . $rows, $val->typeName);
                    $sheet->setCellValue('S' . $rows, $val->priorityName);
                    $sheet->setCellValue('T' . $rows, $val->expected_price);
                    $sheet->setCellValue('U' . $rows, $val->offer_price);
                    $sheet->setCellValue('V' . $rows, $val->address);
                    $sheet->setCellValue('W' . $rows, $ticketStatus[$val->status] ?? 'NA');
                    $sheet->setCellValue('X' . $rows, $val->readStatus);
                    $sheet->setCellValue('Y' . $rows, $val->update_comments);
                    $sheet->setCellValue('Z' . $rows, $val->lead_status);
                    $rows++;
                }
            }

            $spreadSheet->setActiveSheetIndex(0);
            $Excel_writer = new Xls($spreadSheet);

            header('Content-Type: application/vnd.ms-excel');
            header('Content-Disposition: attachment;filename="tickets-report.xls"');
            header('Cache-Control: max-age=0');
            ob_end_clean();
            $Excel_writer->save('php://output');
            exit();
        } catch (Exception $e) {
            Log::info('calls dialled report export error : ' . $e);
        }
    }
}
