<?php

namespace App\Http\Controllers\CRM\Masters;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Services\CRM\Masters\CrmBrandsService;
use App\Services\DataTableService;
use App\Services\Master\PrivilegeService;
use Session;

class CrmBrandController extends Controller
{

    public $privilegeService;
    public $dataTableService;
    public $crmBrandsService;

    public function __construct(PrivilegeService $privilegeService, DataTableService $dataTableService, CrmBrandsService $crmBrandsService)
    {
        $this->privilegeService = $privilegeService;
        $this->dataTableService = $dataTableService;
        $this->crmBrandsService = $crmBrandsService;
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $args = $this->privilegeService->getPrivilegeDetails();
        if ($request->ajax()) {
            $data = $this->crmBrandsService->getData();
            $args->view = false;
            return $this->dataTableService->getDataTable($data, $args);
        }
        $data = clone $args;
        $data->import = false;
        return view('crm.masters.crm-brand.list', compact('data'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return $this->edit();
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        if ($this->crmBrandsService->saveData($request)) {
            Session::flash('success', 'CRM Brands created successfully');
        } else {
            Session::flash('danger', 'CRM Brands created failed');
        }
        return redirect()->route('crm-brand.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id = null)
    {
        $data = $this->crmBrandsService->isNew($id);
        return view('crm.masters.crm-brand.form', compact('data'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        if ($this->crmBrandsService->saveData($request, $id)) {
            Session::flash('success', 'CRM Brands updated successfully');
        } else {
            Session::flash('danger', 'CRM Brands updated failed');
        }
        return redirect()->route('crm-brand.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
