<?php

namespace App\Http\Controllers\CRM\Masters;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Services\CRM\Masters\TicketCategoryService;
use App\Services\DataTableService;
use App\Services\Master\PrivilegeService;
use Session;

class TicketCategoryController extends Controller
{

    public $privilegeService;
    public $dataTableService;
    public $ticketCategoryService;

    public function __construct(PrivilegeService $privilegeService, DataTableService $dataTableService, TicketCategoryService $ticketCategoryService)
    {
        $this->privilegeService = $privilegeService;
        $this->dataTableService = $dataTableService;
        $this->ticketCategoryService = $ticketCategoryService;
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $args = $this->privilegeService->getPrivilegeDetails();
        if ($request->ajax()) {
            $data = $this->ticketCategoryService->getData();
            $args->view = false;
            return $this->dataTableService->getDataTable($data, $args);
        }
        $data = clone $args;
        $data->import = false;
        return view('crm.masters.ticket-category.list', compact('data'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return $this->edit();
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        if ($this->ticketCategoryService->saveData($request)) {
            Session::flash('success', 'Ticket Category created successfully');
        } else {
            Session::flash('danger', 'Ticket Category created failed');
        }
        return redirect()->route('ticket-category.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id = null)
    {
        $data = $this->ticketCategoryService->isNew($id);
        return view('crm.masters.ticket-category.form', compact('data'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        if ($this->ticketCategoryService->saveData($request, $id)) {
            Session::flash('success', 'Ticket Category updated successfully');
        } else {
            Session::flash('danger', 'Ticket Category updated failed');
        }
        return redirect()->route('ticket-category.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
