<?php

namespace App\Http\Controllers;

use App\Services\CommonService;
use Illuminate\Http\Request;
use Session;

class CommonController extends Controller
{

    private $commonService;
    public function __construct(CommonService $commonService)
    {
        $this->commonService = $commonService;
    }

    public function updateStatus(Request $request, $id, $type, $name)
    {
        if ($this->commonService->updateStatus($request, $id, $type, $name)) {
            Session::flash('success', 'Updated successfully');
        } else {
            Session::flash('danger', 'Update failed');
        }
        return redirect()->back();
    }

    public function checkUserEmail(Request $request)
    {
        return $this->commonService->isEmailExists($request);
    }

    public function downloadAttachments($type, $fileName)
    {
        return $this->commonService->downloadAttachments($type, $fileName);
    }

    public function getPrograms(Request $request)
    {
        $programs = $this->commonService->getPrograms($request);
        $return = [
            'status' => true,
            'data' => $programs,
        ];
        return response()->json($return);
    }

    public function getBlocks(Request $request)
    {
        $blocks = $this->commonService->getBlocks($request);
        $return = [
            'status' => true,
            'data' => $blocks,
        ];
        return response()->json($return);
    }

    public function getAwcs(Request $request)
    {
        $awc = $this->commonService->getAwcs($request);
        $return = [
            'status' => true,
            'data' => $awc,
        ];
        return response()->json($return);
    }

    public function getSector(Request $request)
    {
        $sector = $this->commonService->getSector($request);
        $return = [
            'status' => true,
            'data' => $sector,
        ];
        return response()->json($return);
    }

    public function getProgramQuestions(Request $request)
    {
        $questions = $this->commonService->getProgramQuestions($request);
        $return = [
            'status' => true,
            'data' => $questions,
        ];
        return response()->json($return);
    }

    public function getProgramAnswers(Request $request)
    {
        $answer = $this->commonService->getProgramAnswers($request);
        $return = [
            'status' => true,
            'data' => $answer,
        ];
        return response()->json($return);
    }

    public function UpdateStatusAjax(Request $request)
    {

        $id = $request->id;
        $type = config('constants.TYPE_STATUS_UPDATE');
        $name = $request->screenName;
        $redirectUrl = route($request->redirectUrl);

        if ($this->commonService->updateStatus($request, $id, $type, $name)) {
            Session::flash('success', 'Updated successfully');
            $response = [
                'status' => true,
                'redirect' => true,
                'redirect_url' => $redirectUrl,
            ];
        } else {
            Session::flash('danger', 'Update failed');
            $response = [
                'status' => false,
                'redirect' => false,
                'redirect_url' => $redirectUrl,
            ];
        }
        return response()->json($response);
    }

    public function updateTheme(Request $request)
    {
        if ($request->status == '1') {
            Session::put('sessionTheme', config('constants.SESSION_THEME'));
        } else {
            Session::put('sessionTheme', '');
        }
        $response = [
            'status' => true,
            'redirect' => false,
            'redirect_url' => null,
        ];
        return response()->json($response);
    }

}
