<?php

namespace App\Http\Controllers;

use App\Models\Feedback;
use App\Services\DataTableService;
use App\Services\FeedbackService;
use App\Services\Master\PrivilegeService;
use Exception;
use Illuminate\Http\Request;
use Session;

class FeedbackController extends Controller
{

    public $feedbackService;
    public $dataTableService;
    public $privilegeService;

    public function __construct(FeedbackService $feedbackService, DataTableService $dataTableService, PrivilegeService $privilegeService)
    {
        $this->feedbackService = $feedbackService;
        $this->dataTableService = $dataTableService;
        $this->privilegeService = $privilegeService;
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $args = $this->privilegeService->getPrivilegeDetails();
        if ($request->ajax()) {
            $data = $this->feedbackService->getBenFeedbackList($request);
            $args->edit = false;
            $args->active = false;
            $args->delete = false;
            // $args->showRecording = showRecordings();
            return $this->dataTableService->getDataTable($data, $args);
        }
        $data = clone $args;
        $data->import = false;
        $data->create = false;
        return view('feedback.list', compact('data'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
    }

    public function newFeedback($id = null)
    {
        $callerId = decrypt($id);
        $data = $this->feedbackService->isNew($callerId);
        return view('feedback.form', compact('data'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $callerId = decrypt($id);
        $data = $this->feedbackService->getFeedbackDetails($callerId);
        $data->breadcrumbName = 'Details';
        $data->breadcrumbAction = route('feedback.index');
        $data->breadcrumbTitle = 'Feedback';
        return view('feedback.show', compact('data'));
    }

    public function resolveFeedback(Request $request)
    {
        $redirectUrl = $request->has('redirectUrl') ? $request->redirectUrl : route('complaint.index');
        if ($this->feedbackService->resolveFeedback($request)) {
            Session::flash('success', 'Complaint Resolved successfully');
        } else {
            Session::flash('danger', 'Complaint Resolved failed');
        }
        return redirect()->back();
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id = null)
    {
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }

    public function saveFeedback(Request $request)
    {
        if ($this->feedbackService->saveFeedbackChild($request)) {
            Session::flash('success', 'Customer created successfully');
        } else {
            Session::flash('danger', 'Customer creation failed');
        }
        return redirect()->route('caller.index');
    }

    public function viewExternalFeedback(Request $request, $id = null)
    {
        if ($id) {
            $feedback = Feedback::find($id);
            if ($id) {
                $id = $feedback->beneficiary_ref_id;
                $data = $this->feedbackService->getFeedbackDetails($id);
                if ($data->feedback && count($data->feedback) > 0) {
                    $this->feedbackService->removeHtmlTagsFromString($data->feedback);
                }
                return view('feedback.external-show', compact('data'));
            } else {
                throw new Exception('feedback id not found');
            }
        } else {
            throw new Exception('feedback id not found');
        }
    }

    public function saveFeedbackApp(Request $request)
    {
        $data = $this->feedbackService->saveFeedbackApp($request);
        if ($data->status) {
            return sendResponse($data, $data->msg);
        }
        return sendError($data->msg);
    }

    public function getFeedbackHistory(Request $request)
    {
        return $this->feedbackService->getFeedbackHistory($request);
    }
}
