<?php

namespace App\Http\Controllers\Masters;

use App\Services\DataTableService;
use Illuminate\Http\Request;
use Session;
use App\Http\Controllers\Controller;
use App\Services\CallReasonService;
use App\Services\Master\PrivilegeService;

class CallReasonController extends Controller
{

    public $callReasonService;
    public $dataTableService;
    public $privilegeService;

    public function __construct(CallReasonService $callReasonService, DataTableService $dataTableService, PrivilegeService $privilegeService)
    {
        $this->callReasonService = $callReasonService;
        $this->dataTableService = $dataTableService;
        $this->privilegeService = $privilegeService;
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $args = $this->privilegeService->getPrivilegeDetails();

        if ($request->ajax()) {
            $data = $this->callReasonService->getData();
            $args->view = false;
            return $this->dataTableService->getDataTable($data, $args);
        }

        $data = clone $args;
        $data->import = false;

        return view('master.call-reason.list', compact('data'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return $this->edit();
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        if ($this->callReasonService->saveData($request)) {
            Session::flash('success', 'Call Reason created successfully');
        } else {
            Session::flash('danger', 'Call Reason creation failed');
        }
        return redirect()->route('call-reasons.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
       
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id = null)
    {
        $data = $this->callReasonService->isNew($id);
        return view('master.call-reason.form', compact('data'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        if ($this->callReasonService->saveData($request, $id)) {
            Session::flash('success', 'Call Reason updated successfully');
        } else {
            Session::flash('danger', 'Call Reason updated failed');
        }
        return redirect()->route('call-reasons.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
