<?php

namespace App\Http\Controllers\Masters;

use App\Http\Controllers\Controller;
use App\Services\DataTableService;
use App\Services\Master\ClusterService;
use App\Services\Master\PrivilegeService;
use App\Models\Masters\BranchMaster;
use Illuminate\Http\Request;
use Illuminate\Support\Collection;
use Session;

class ClusterMasterController extends Controller
{

    public $clusterService;
    public $dataTableService;
    public $privilegeService;

    public function __construct(ClusterService $clusterService, DataTableService $dataTableService, PrivilegeService $privilegeService)
    {
        $this->clusterService = $clusterService;
        $this->dataTableService = $dataTableService;
        $this->privilegeService = $privilegeService;
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $args = $this->privilegeService->getPrivilegeDetails();

        if ($request->ajax()) {
            $data = $this->clusterService->getData();
            return $this->dataTableService->getDataTable($data, $args);
        }
        $data = clone $args;
        $data->import = false;

        return view('master.cluster.list', compact('data'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
       
        return $this->edit();
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        if ($this->clusterService->saveData($request)) {
            Session::flash('success', 'Cluster created successfully');
        } else {
            Session::flash('danger', 'Cluster creation failed');
        }
        return redirect()->route('cluster-master.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $id = decrypt($id);
        $data = $this->clusterService->showData($id);
        $data->breadcrumbName = 'Details';
        $data->breadcrumbAction = route('cluster-master.index');
        $data->breadcrumbTitle = 'Cluster';
        
        return view('master.cluster.show', compact('data'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id = null)
    {
        $data = $this->clusterService->isNew($id);
        return view('master.cluster.form', compact('data'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        if ($this->clusterService->saveData($request, $id)) {
            Session::flash('success', 'Cluster updated successfully');
        } else {
            Session::flash('danger', 'Cluster updated failed');
        }
        return redirect()->route('cluster-master.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
