<?php

namespace App\Http\Controllers\Masters;

use App\Http\Controllers\Controller;
use App\Services\DataTableService;
use App\Services\FeedbackService;
use App\Services\Master\PrivilegeService;
use Illuminate\Http\Request;
use Session;

class FeedbackMasterController extends Controller
{

    public $feedbackService;
    public $dataTableService;
    public $privilegeService;

    public function __construct(FeedbackService $feedbackService, DataTableService $dataTableService, PrivilegeService $privilegeService)
    {
        $this->feedbackService = $feedbackService;
        $this->dataTableService = $dataTableService;
        $this->privilegeService = $privilegeService;
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $args = $this->privilegeService->getPrivilegeDetails();
        if ($request->ajax()) {
            $data = $this->feedbackService->getFeedbackMasters('master');
            $args->showCriticalPoints = true;
            return $this->dataTableService->getDataTable($data, $args);
        }
        $data = clone $args;
        $data->import = false;

        return view('feedback-master.list', compact('data'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return $this->edit();
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $uniqueId = $request->has('uniqueId') ? $request->get('uniqueId') : '';
        $msg = 'Master creation failed';
        if ($uniqueId) {
            $msg = 'Master update failed';
        }
        $response = [
            'status' => false,
            'msg' => $msg,
        ];

        $res = $this->feedbackService->saveData($request);

        if ($res == 'exists') {
            $status = false;
            $msg = 'Scheme and Program Already exists. use edit option';
        } else if ($res == 'success') {
            $status = true;
            $msg = 'Master created Successfully';
            if ($uniqueId) {
                $msg = 'Master updated Successfully';
            }
        }

        $response = [
            'status' => $status,
            'msg' => $msg,
        ];

        return response()->json($response);
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $id = decrypt($id);
        $data = $this->feedbackService->getFeedbackMasterDetails($id);
        $data->breadcrumbName = 'Details';
        $data->breadcrumbAction = route('feedback-master.index');
        $data->breadcrumbTitle = 'Feedback';
        $data->formContent = $this->feedbackService->createFeedbackForm($data->contents);
        return view('feedback-master.show', compact('data'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id = null)
    {
        $data = $this->feedbackService->isNewMaster($id);
        return view('feedback-master.form', compact('data'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {

    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }

    public function getcriticalPonitView($id)
    {
        $id = decrypt($id);
        $data = $this->feedbackService->getFeedbackMasterDetails($id);
        $data->breadcrumbName = 'Critical Points';
        $data->breadcrumbAction = route('feedback-master.index');
        $data->breadcrumbTitle = 'Feedback';
        $data->formContent = $this->feedbackService->createFeedbackForm($data->contents, 'critical-points');
        $data->route = route('feedback-master.updateCriticalPoints');
        $data->method = 'POST';
        return view('feedback-master.critical-points', compact('data'));
    }

    public function updateCriticalPoints(Request $request)
    {
        if ($this->feedbackService->updateCriticalPoints($request)) {
            Session::flash('success', 'Updated successfully');
        } else {
            Session::flash('danger', 'Update failed');
        }

        return redirect()->route('feedback-master.index');

    }

}
