<?php

namespace App\Http\Controllers\Masters;

use App\Http\Controllers\Controller;
use App\Services\DataTableService;
use App\Services\Master\PrivilegeService;
use App\Services\Master\ResolveReasonService;
use Illuminate\Http\Request;
use Session;

class ResolveReasonController extends Controller
{

    public $resolveReasonService;
    public $dataTableService;
    public $privilegeService;

    public function __construct(ResolveReasonService $resolveReasonService, DataTableService $dataTableService, PrivilegeService $privilegeService)
    {
        $this->resolveReasonService = $resolveReasonService;
        $this->dataTableService = $dataTableService;
        $this->privilegeService = $privilegeService;
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $args = $this->privilegeService->getPrivilegeDetails();

        if ($request->ajax()) {
            $data = $this->resolveReasonService->getData();
            $args->view = false;
            return $this->dataTableService->getDataTable($data, $args);
        }

        $data = clone $args;
        $data->import = false;

        return view('master.resolve-reason.list', compact('data'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return $this->edit();
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        if ($this->resolveReasonService->saveData($request)) {
            Session::flash('success', 'Resolve Reason created successfully');
        } else {
            Session::flash('danger', 'Resolve Reason creation failed');
        }
        return redirect()->route('resolve-reasons.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id = null)
    {
        $data = $this->resolveReasonService->isNew($id);
        return view('master.resolve-reason.form', compact('data'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        if ($this->resolveReasonService->saveData($request, $id)) {
            Session::flash('success', 'Resolve Reason updated successfully');
        } else {
            Session::flash('danger', 'Resolve Reason updated failed');
        }
        return redirect()->route('resolve-reasons.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
