<?php

namespace App\Http\Controllers\Masters;

use App\Models\User;
use App\Services\DataTableService;
use App\Services\UserService;
use App\Utilities\AppClass;
use Illuminate\Http\Request;
use Illuminate\Support\Collection;
use Session;
use App\Http\Controllers\Controller;
use App\Services\Master\PrivilegeService;

class UserController extends Controller
{

    public $userService;
    public $dataTableService;
    public $privilegeService;

    public function __construct(UserService $userService, DataTableService $dataTableService, PrivilegeService $privilegeService)
    {
        $this->userService = $userService;
        $this->dataTableService = $dataTableService;
        $this->privilegeService = $privilegeService;
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $args = $this->privilegeService->getPrivilegeDetails();

        if ($request->ajax()) {
            $data = $this->userService->getUserData();
            $args->view = false;
            return $this->dataTableService->getDataTable($data, $args);
        }

        $data = clone $args;
        $data->import = false;

        return view('user.list', compact('data'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return $this->edit();
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        if ($this->userService->saveUserData($request)) {
            Session::flash('success', 'User created successfully');
        } else {
            Session::flash('danger', 'User creation failed');
        }
        return redirect()->route('user.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id = null)
    {
        $data = $this->userService->isNew($id);
        return view('user.form', compact('data'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        if ($this->userService->saveUserData($request, $id)) {
            Session::flash('success', 'User updated successfully');
        } else {
            Session::flash('danger', 'User updated failed');
        }
        return redirect()->route('user.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }


}
