<?php

namespace App\Http\Controllers\Reports;

use App\Http\Controllers\Controller;
use App\Services\DataTableService;
use Illuminate\Http\Request;
use App\Services\Master\PrivilegeService;
use App\Services\Reports\CRMReportService;
use Session;

class CRMReportController extends Controller
{
    public $privilegeService;
    public $dataTableService;
    public $cRMReportService;

    public function __construct(PrivilegeService $privilegeService, DataTableService $dataTableService, CRMReportService $cRMReportService)
    {
        $this->privilegeService = $privilegeService;
        $this->dataTableService = $dataTableService;
        $this->cRMReportService = $cRMReportService;
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $args = $this->privilegeService->getPrivilegeDetails();

        if ($request->ajax()) {
            $data = $this->cRMReportService->getData($request);
            $args->showTimeStamp = true;
            return $this->dataTableService->getDataTableReports($data, $args);
        }
        $data = clone $args;
        $data->create = false;
        $data->import = false;
        $data->action = route('navigateReport');
        $data->method = 'POST';
        return view('reports.crm-report', compact('data'));
    }

}
