<?php

namespace App\Http\Controllers\Reports;

use App\Http\Controllers\Controller;
use App\Services\DataTableService;
use Illuminate\Http\Request;
use App\Services\Master\PrivilegeService;
use App\Services\Reports\ConnectedConvertedReportService;
use Session;

class ConnectedConvertedReportController extends Controller
{
    public $privilegeService;
    public $dataTableService;
    public $connectedConvertedReportService;

    public function __construct(PrivilegeService $privilegeService, DataTableService $dataTableService, ConnectedConvertedReportService $connectedConvertedReportService)
    {
        $this->privilegeService = $privilegeService;
        $this->dataTableService = $dataTableService;
        $this->connectedConvertedReportService = $connectedConvertedReportService;
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $args = $this->privilegeService->getPrivilegeDetails();

        if ($request->ajax()) {
            $data = $this->connectedConvertedReportService->getData($request);
            return $this->dataTableService->getDataTableReports($data, $args);
        }
        $data = clone $args;
        $data->create = false;
        $data->import = false;
        $data->action = route('navigateReport');
        $data->method = 'POST';
        return view('reports.connected-converted-report', compact('data'));
    }

}
