<?php

namespace App\Http\Controllers\Reports;

use App\Http\Controllers\Controller;
use App\Services\DataTableService;
use Illuminate\Http\Request;
use App\Services\Master\PrivilegeService;
use App\Services\Reports\EnquiryReportService;

class EnquiryReportController extends Controller
{
    public $privilegeService;
    public $dataTableService;
    public $enquiryReportService;

    public function __construct(PrivilegeService $privilegeService, DataTableService $dataTableService, EnquiryReportService $enquiryReportService)
    {
        $this->privilegeService = $privilegeService;
        $this->dataTableService = $dataTableService;
        $this->enquiryReportService = $enquiryReportService;
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $args = $this->privilegeService->getPrivilegeDetails();

        if ($request->ajax()) {
            $data = $this->enquiryReportService->getData($request);
            $args->view = true;
            $args->showAction = true;
            return $this->dataTableService->getDataTableReports($data, $args);
        }
        $data = clone $args;
        $data->create = false;
        $data->import = false;
        $data->action = route('navigateReport');
        $data->method = 'POST';
        return view('reports.enquiry-report', compact('data'));
    }

}
