<?php

namespace App\Http\Controllers\Reports;

use App\Http\Controllers\Controller;
use App\Services\DataTableService;
use Illuminate\Http\Request;
use App\Services\Master\PrivilegeService;
use App\Services\Reports\JustDialReportService;
use Session;

class JustDialReportController extends Controller
{
    public $privilegeService;
    public $dataTableService;
    public $justDialReportService;

    public function __construct(PrivilegeService $privilegeService, DataTableService $dataTableService, JustDialReportService $justDialReportService)
    {
        $this->privilegeService = $privilegeService;
        $this->dataTableService = $dataTableService;
        $this->justDialReportService = $justDialReportService;
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $args = $this->privilegeService->getPrivilegeDetails();

        if ($request->ajax()) {
            $data = $this->justDialReportService->getData($request);
            $args->view = true;
            $args->showAction = true;
            return $this->dataTableService->getDataTableReports($data, $args);
        }
        $data = clone $args;
        $data->create = false;
        $data->import = false;
        $data->action = route('navigateReport');
        $data->method = 'POST';
        return view('reports.just-dial-leads-report', compact('data'));
    }

    function updateLeadStatus(Request $request)
    {
        if ($this->justDialReportService->updateLeadStatus($request)) {
            Session::flash('success', 'Lead updated successfully');
        } else {
            Session::flash('danger', 'Lead updated failed');
        }
        return redirect()->back();
    }
}
