<?php

namespace App\Http\Controllers\Reports;

use App\Http\Controllers\Controller;
use App\Services\DataTableService;
use Illuminate\Http\Request;
use App\Services\Master\PrivilegeService;
use App\Services\Reports\NocallAgentsService;

class NocallAgentReportController extends Controller
{
    public $privilegeService;
    public $dataTableService;
    public $nocallAgentsService;


    public function __construct(PrivilegeService $privilegeService, DataTableService $dataTableService, NocallAgentsService $nocallAgentsService)
    {
        $this->privilegeService = $privilegeService;
        $this->dataTableService = $dataTableService;
        $this->nocallAgentsService = $nocallAgentsService;
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $args = $this->privilegeService->getPrivilegeDetails();

        // Fetch initial data for the current date if the request is not AJAX
        if ($request->ajax()) {
            $data = $this->nocallAgentsService->getNoCallAgents($request);
            return $this->dataTableService->getDataTableReports($data, $args);
        }

        $data = clone $args;
        $data->create = false;
        $data->import = false;
        $data->action = route('navigateReport');
        $data->method = 'POST';
        return view('reports.nocall-agents-report', compact('data'));
    }
}
