<?php

namespace App\Http\Controllers\Reports;

use App\Http\Controllers\Controller;
use App\Services\DataTableService;
use Illuminate\Http\Request;
use App\Services\Master\PrivilegeService;
use App\Services\Reports\PresentLoggedInService;

class PresentLoggedInReportController extends Controller
{
    public $privilegeService;
    public $dataTableService;
    public $presentLoggedInService;

    public function __construct(PrivilegeService $privilegeService, DataTableService $dataTableService, PresentLoggedInService $presentLoggedInService)
    {
        $this->privilegeService = $privilegeService;
        $this->dataTableService = $dataTableService;
        $this->presentLoggedInService = $presentLoggedInService;
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $args = $this->privilegeService->getPrivilegeDetails();

        if ($request->ajax()) {
            $data = $this->presentLoggedInService->getData($request);
            return $this->dataTableService->getDataTableReports($data, $args);
        }
        $data = clone $args;
        $data->create = false;
        $data->import = false;
        $data->action = route('navigateReport');
        $data->method = 'POST';
        return view('reports.present-loggedin-report', compact('data'));
    }
}
