<?php

namespace App\Http\Controllers\Reports;

use App\Http\Controllers\Controller;
use App\Services\DataTableService;
use App\Services\Master\PrivilegeService;
use App\Services\Reports\ProgramwiseService;
use Illuminate\Http\Request;

class ProgramwiseReportController extends Controller
{
    public $programwiseService;
    public $dataTableService;
    public $privilegeService;

    public function __construct(ProgramwiseService $programwiseService, DataTableService $dataTableService, PrivilegeService $privilegeService)
    {
        $this->programwiseService = $programwiseService;
        $this->dataTableService = $dataTableService;
        $this->privilegeService = $privilegeService;
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        if ($request->ajax()) {
            return $this->getReport($request);
        }
        $data = $this->privilegeService->getPrivilegeDetails('reports');
        $data->action = route('navigateReport');
        $data->method = 'POST';
        return view('reports.programwise', compact('data'));
    }

    public function getReport(Request $request)
    {
        $data = $this->programwiseService->getProgramwisereport($request);
        $html = view('reports.programwise-details', compact('data'))->render();
        $response = [
            'status' => true,
            'redirect' => false,
            'redirect_url' => null,
            'html' => $html,
            'renderId' => '#report_content',
        ];
        return response()->json($response);
    }


}
