<?php

namespace App\Http\Controllers\Transactions;

use App\Http\Controllers\Controller;
use App\Imports\ResendCouponCodes;
use App\Services\CommonService;
use App\Services\DataTableService;
use App\Services\Master\PrivilegeService;
use App\Services\Transactions\ResendCouponsService;
use App\Services\Transactions\SendCouponCodeService;
use Illuminate\Http\Request;
use Session;
use Maatwebsite\Excel\Facades\Excel;
use Log;

class ResendCouponsController extends Controller
{

    public $resendCouponsService;
    public $dataTableService;
    public $privilegeService;

    public function __construct(ResendCouponsService $resendCouponsService, DataTableService $dataTableService, PrivilegeService $privilegeService)
    {
        $this->resendCouponsService = $resendCouponsService;
        $this->dataTableService = $dataTableService;
        $this->privilegeService = $privilegeService;
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $data = $this->resendCouponsService->isNew();
        return view('transactions.resend-coupons', compact('data'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return $this->edit();
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        try {
            $file = $request->file('attachments');
            // Perform the import
            Excel::import(
                new ResendCouponCodes(
                    app(CommonService::class),
                    app(SendCouponCodeService::class)
                ),
                $file
            );
            Session::flash('success', 'Coupon Resend successfully');
        } catch (\Exception $e) {
            Log::info('ResendCouponCodes error : ' . $e->getMessage());
            Session::flash('danger', 'Import Failed');
        }
        return redirect()->route('resend-coupons.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id = null)
    {
        $data = $this->resendCouponsService->isNew($id);
        return view('master.brand.form', compact('data'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        if ($this->resendCouponsService->saveData($request, $id)) {
            Session::flash('success', 'Brand updated successfully');
        } else {
            Session::flash('danger', 'Brand updated failed');
        }
        return redirect()->route('brand.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
