<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Http;

class WebhookController extends Controller
{
    public function store(Request $request)
    {
        $timestamp = now()->toISOString();
        $ip = $request->ip();

        // Extract inputs from query/body (supports GET/POST)
        $phone = $request->input('phone');
        $name = $request->input('name');
        $product = $request->input('product');
        $city = $request->input('city');
        $storename = $request->input('storename');
        $coupon = $request->input('coupon');
        $source_url = $request->input('source_url');

        // Prevent extremely large bodies in logs
        $payload = $request->all();
        $jsonPayload = json_encode($payload);
        if (strlen($jsonPayload) > 10000) {
            $jsonPayload = substr($jsonPayload, 0, 10000) . '... [truncated]';
        }
        
        try {
            $response = Http::withHeaders([
                'Content-Type' => $request->header('Content-Type', 'application/json'),
            ])->post('https://mydoersapp.com/viveks-v3-beta/api/request-log', $request->all());
        } catch (\Exception $e) {
            // Log if the forward request fails
            Log::channel('viveks-wati-webhook')->error('Failed to forward request', [
                'error' => $e->getMessage(),
                'time' => $timestamp,
                'ip' => $ip,
            ]);
        }
    
        Log::channel('viveks-wati-webhook')->info('Webhook request', [
            'time' => $timestamp,
            'ip' => $ip,
            'fields' => [
                'phone' => $phone,
                'name' => $name,
                'product' => $product,
                'city' => $city,
                'storename' => $storename,
                'coupon' => $coupon,
                'source_url' => $source_url
            ],
            // 'headers' => $request->headers->all(),
            // 'payload' => $jsonPayload,
        ]);

        return response()->json(['status' => 'ok']);
    }
}
