<?php
 
namespace App\Imports;
 
use App\Models\Masters\AgentMaster;
use App\Models\Masters\BranchMaster;
use App\Models\Masters\BrandMaster;
use App\Models\Masters\ClassMaster;
use App\Models\Masters\DesignationMaster;
use App\Models\RoleMaster;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Collection;
use Maatwebsite\Excel\Concerns\ToCollection;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use DB;
 
class CreateAgents implements ToCollection
{
 
    public $rows;
 
    public function __construct() {}
 
    public function collection(Collection $collection)
    {
 
        try {
            DB::beginTransaction();
            $this->rows = $collection;
            if (count($this->rows) > 0) {
                $this->processData();
            }
            DB::commit();
        } catch (\Exception $e) {
            DB::rollback();
            dd($e->getMessage());
        }
    }
 
    function getBranch($name)
    {
        $branch = BranchMaster::select('id')->where('name', trim($name))->first();
        if (!$branch) {
            $branch = new BranchMaster();
            $branch->name = trim($name);
            $branch->code = trim($name);
            $branch->save();
        }
        return $branch->id;
    }
 
    function getDesignation($name)
    {
        $data = DesignationMaster::select('id')->where('name', trim($name))->first();
        if (!$data) {
            $data = new DesignationMaster();
            $data->name = trim($name);
            $data->save();
        }
        return $data->id;
    }
 
    function getBrand($name)
    {
        $data = BrandMaster::select('id')->where('name', trim($name))->first();
        if (!$data) {
            $data = new BrandMaster();
            $data->name = trim($name);
            $data->save();
        }
        return $data->id;
    }
 
    function getClass($name)
    {
        $data = ClassMaster::select('id')->where('name', trim($name))->first();
        if (!$data) {
            $data = new ClassMaster();
            $data->name = trim($name);
            $data->save();
        }
        return $data->id;
    }
 
    public function processData()
    {
        $rows = $this->rows;
        if ($rows) {
            foreach ($rows as $key => $user) {
                if ($key > 0) {
 
                    $phone = isset($user[3]) ? $user[3] : null;
                    $userDetails = User::where('email', $phone)->count();
                    if ($userDetails == 0) {
                        $name = isset($user[1]) ? $user[1] : null;
                        $branch = $this->getBranch($user[2]);
                        $designation = $this->getDesignation($user[5]);
                        $password = '12345';
                        $role = RoleMaster::ROLE_AGENT;
                        $brand = $this->getBrand($user[6]);
                        $class = $this->getClass($user[7]);
                        $crmLeadAssign = null;
                        if (trim($user[8]) == 'YES') {
                            $crmLeadAssign = 1;
                        }
 
                        $data = new AgentMaster();
                        $data->name = $name;
                        $data->branch_id = $branch;
                        $data->phone = $phone;
                        $data->designation = $designation;
                        $data->crm_lead_assign = $crmLeadAssign;
                        $data->brand = $brand;
                        $data->class = $class;
                        $data->role = $role;
                        $data->save();
                        $lastId = $data->id;
                        if ($lastId) {
                            //save data to user table
                            $user = new User();
                            $user->password = Hash::make($password);
                            $user->name = $name;
                            $user->email = $phone;
                            $user->role = $role;
                            $user->user_type = User::USER_TYPE_AGENT;
                            $user->reference_id = $lastId;
                            $user->save();
                        }
                    }
                }
            }
        }
    }
}
