<?php

namespace App\Imports;

use App\Models\Masters\AgentMaster;
use App\Models\CRM\Masters\CrmProducts;
use App\Models\Masters\BranchMaster;
use App\Models\CRM\Masters\CrmBrands;
use App\Models\Masters\ClassMaster;
use App\Models\Masters\DesignationMaster;
use App\Models\RoleMaster;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Collection;
use Maatwebsite\Excel\Concerns\ToCollection;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use DB;

class CreateCrmProducts implements ToCollection
{

    public $rows;

    public function __construct() {}

    public function collection(Collection $collection)
    {

        try {
            DB::beginTransaction();
            $this->rows = $collection;
            if (count($this->rows) > 0) {
                $this->processData();
            }
            DB::commit();
        } catch (\Exception $e) {
            DB::rollback();
            dd($e->getMessage());
        }
    }
    private function getCrmBrand($name)
    {
        // dd($name);
        $brand = CrmBrands::select('id')->where('name', trim($name))->first();
        return $brand->id; // Return brand ID
    }
    public function processData()
    {
        $rows = $this->rows;

        foreach ($rows as $key => $row) {
            if ($key == 0) continue; // skip header row
            // dd($row);
            $productName = isset($row[1]) ? trim($row[1]) : null; // Product name from Excel
            $brandName = isset($row[2]) ? trim($row[2]) : null;   // Brand name from Excel

            if (!empty($productName) && !empty($brandName)) {

                $brandId = $this->getCrmBrand($brandName); // Fetch brand ID from crmbrand table

                // dd($brandId);
                $crmProduct = new CrmProducts();
                $crmProduct->name = $productName;        // Product name from Excel
                $crmProduct->brand = $brandId;           // Brand ID from crmbrand table
                $crmProduct->description = $productName; // Product name as description
                $crmProduct->save();
            }
        }
    }
}
