<?php

namespace App\Imports;

use App\Models\Masters\EscalationMatrix;
use App\Models\Masters\EscalationMatrixLevels;
use App\Services\ImportService;
use App\Utilities\AppClass;
use Illuminate\Support\Collection;
use Log;
use Maatwebsite\Excel\Concerns\ToCollection;

class EscalationLevelImport implements ToCollection
{
    /**
     * @param Collection $collection
     */

    public $rows;
    public $scheme;
    public $program;
    public $block;
    public $awc;
    public $district;
    public $errors;
    public $excelData;
    public $escalationData;

    public function __construct()
    {
        $this->errors = new Collection();
        $this->excelData = new Collection();
        $this->importService = new ImportService();
    }

    public function collection(Collection $collection)
    {

        $this->rows = $collection;
        $this->scheme = $this->importService->getSchemes();
        $this->program = $this->importService->getPrograms();

        if (count($this->rows) > 0) {
            $this->processData();
        }

    }

    public function processData()
    {
        foreach ($this->rows as $key => $row) {
            if ($key > 0) {
                $district = isIssetValueArray($row, 1);
                $block = isIssetValueArray($row, 2);
                $sector = isIssetValueArray($row, 3);
                $awc = isIssetValueArray($row, 4);
                $awcWorker = isIssetValueArray($row, 6);
                $mobile = isIssetValueArray($row, 7);
                $blockId = null;
                $awcId = null;

                if ($mobile != '') {
                    // foreach ($this->scheme as $scheme) {
                    //     $scheme = $scheme->id;
                    //     foreach ($this->program as $program) {
                    //         $program = $program->id;

                    $args = new AppClass();
                    $args->create = true;
                    $args->state = 31;

                    $districtId = $this->importService->getDistrictByName($args, $district);

                    if ($districtId) {
                        $args->district = $districtId;
                        $blockId = $this->importService->getBlockByName($args, $block);
                        if ($blockId) {
                            $args->block = $blockId;
                            $sectorId = $this->importService->getSectorByName($args, $sector);
                            if ($sectorId) {
                                $args->sector = $sectorId;
                                $awcId = $this->importService->getAwcByName($args, $awc);
                            }

                        }
                    }

                    $data = new AppClass();
                    $data->scheme = null;
                    $data->program = null;
                    $data->district = $districtId;
                    $data->block = $blockId;
                    $data->sector = $sectorId;
                    $data->awc = $awcId;
                    $data->awcName = $awcWorker;
                    $data->level = 1;
                    $data->mobile = $mobile;
                    $data->districtName = $district;
                    $data->days = 3;
                    $data->resolveLevel = 1;

                    $this->createEscalationMatrix($data);
                    //     }
                    // }
                }

            }
        }
    }

    public function createEscalationMatrix($data)
    {
        $escalationId = $this->getEscalationExists($data);
        if ($escalationId) {
            $level = new EscalationMatrixLevels();
            $level->escalation_reference_id = $escalationId;
            $level->name = $data->awcName;
            $level->level = $data->level;
            $level->mobile = $data->mobile;
            $level->days = $data->days;
            $level->district = $data->districtName;
            $level->resolving_officer = $data->resolveLevel;
            $level->save();
        } else {
            Log::info('escalation id not found ' . json_encode($data));
        }
    }

    public function getEscalationExists($data)
    {

        $esc = EscalationMatrix::where('scheme_id', $data->scheme)
            ->where('program_id', $data->program)
            ->where('district_id', $data->district)
            ->where('block_id', $data->block)
            ->where('awc_id', $data->awc)
            ->whereStatus(EscalationMatrix::STATUS_ACTIVE)
            ->first();
        if ($esc) {
            return $esc->id;
        }

        //create new escalation
        $escalation = new EscalationMatrix();
        $escalation->scheme_id = $data->scheme;
        $escalation->program_id = $data->program;
        $escalation->district_id = $data->district;
        $escalation->block_id = $data->block;
        $escalation->awc_id = $data->awc;
        $escalation->sector_id = $data->sector;
        $escalation->save();
        return $escalation->id;
    }

}
