<?php

namespace App\Imports;

use App\Models\Masters\AwcMaster;
use App\Models\Masters\BlockMaster;
use App\Models\Masters\CityMaster;
use App\Models\Masters\EscalationMatrix;
use App\Models\Masters\EscalationMatrixLevels;
use App\Utilities\AppClass;
use Illuminate\Support\Collection;
use Log;
use Maatwebsite\Excel\Concerns\ToCollection;

class EscalationLevelOneImport implements ToCollection
{
    public $rows;

    public function __construct()
    {
    }

    public function collection(Collection $collection)
    {
        $this->rows = $collection;
        if (count($this->rows) > 0) {
            $this->processData();
        }
    }

    public function processData()
    {
        $rows = $this->rows;
        $rows = $this->removeNullValues($rows);
        if ($rows) {
            foreach ($rows as $levelOfficer) {
                Log::info('code : ' . $levelOfficer->awcCode);
                $escalation = new EscalationMatrix();
                $escalation->district_id = $levelOfficer->districtId;
                $escalation->block_id = $levelOfficer->blockId;
                $escalation->sector_id = $levelOfficer->sectorId;
                $escalation->awc_id = $levelOfficer->awcId;
                $escalation->save();
                $refId = $escalation->id;
                if ($refId) {
                    $levels = new EscalationMatrixLevels();
                    $levels->escalation_reference_id = $refId;
                    $levels->name = $levelOfficer->name;
                    $levels->level = 1;
                    $levels->mobile = $levelOfficer->mobile;
                    $levels->district = $levelOfficer->districtName;
                    $levels->days = 7;
                    $levels->save();
                }
            }
        }
    }

    public function removeNullValues($rows)
    {
        $data = new Collection();
        foreach ($rows as $key => $user) {
            if ($key > 0) {
                $mobile = str_replace(' ', '', $user[3]);
                $awcDetails = $this->getAwcDetails(trim($user[1]));
                if ($awcDetails) {
                    $new = new AppClass();
                    $new->name = trim($user[2]);
                    $new->mobile = trim($mobile);
                    $new->districtId = $awcDetails->district_id;
                    $new->blockId = $awcDetails->block_id;
                    $new->sectorId = $awcDetails->sector_id;
                    $new->awcId = $awcDetails->id;
                    $new->awcCode = trim($user[1]);
                    $new->districtName = trim($user[0]);
                    $data->add($new);
                } else {
                    // dd('awc not found : ' . $user[1]);
                    Log::info('awc not found : ' . $user[1]);
                }
            }
        }
        return $data;
    }

    public function getAwcDetails($code)
    {
        $awc = AwcMaster::where('code', $code)->first();
        return $awc;
    }
}
