<?php

namespace App\Imports;

use App\Models\Masters\EscalationMatrix;
use App\Models\Masters\EscalationMatrixLevels;
use App\Services\ImportService;
use App\Utilities\AppClass;
use Illuminate\Support\Collection;
use Log;
use Maatwebsite\Excel\Concerns\ToCollection;

class EscalationLevelThreeImport implements ToCollection
{
    /**
     * @param Collection $collection
     */

    public $rows;
    public $scheme;
    public $program;
    public $block;
    public $awc;
    public $district;
    public $errors;
    public $excelData;

    public function __construct()
    {
        $this->errors = new Collection();
        $this->importService = new ImportService();
    }

    public function collection(Collection $collection)
    {

        $this->rows = $collection;
        $this->scheme = $this->importService->getSchemes();
        $this->program = $this->importService->getPrograms();
        if (count($this->rows) > 0) {
            $this->processData();
        }

    }

    public function processData()
    {
        $oldDistrict = '';

        foreach ($this->rows as $key => $row) {
            if ($key > 1) {
                $district = isIssetValueArray($row, 1);
                $block = isIssetValueArray($row, 2);
                $awcWorker = isIssetValueArray($row, 7);
                $mobile = isIssetValueArray($row, 8);
                $blockId = null;
                $awcId = null;

                if ($mobile != '') {
                    // foreach ($this->scheme as $scheme) {
                    //     $scheme = $scheme->id;
                    //     foreach ($this->program as $program) {
                    //         $program = $program->id;

                    $insert = true;

                    $args = new AppClass();
                    $args->state = 31;
                    $args->create = false;

                    if ($district == '' || $district == null) {
                        $district = $oldDistrict;
                    }

                    $districtId = $this->importService->getDistrictByName($args, $district);
                    $oldDistrict = $district;

                    if ($districtId) {
                        $args->district = $districtId;
                        $blockId = $this->importService->getBlockByName($args, $block);
                        if (!$blockId) {
                            Log::info($block . ' block not found');
                            $insert = false;
                        }
                    } else {
                        Log::info($district . ' district not found');
                        $insert = false;
                    }

                    $data = new AppClass();
                    $data->scheme = null;
                    $data->program = null;
                    $data->district = $districtId;
                    $data->block = $blockId;
                    $data->awc = $awcId;
                    $data->awcName = $awcWorker;
                    $data->level = 3;
                    $data->mobile = $mobile;
                    $data->districtName = $district;
                    $data->days = 3;
                    $data->resolveLevel = 3;

                    if ($insert) {
                        $this->createEscalationMatrix($data);
                    }
                    //     }
                    // }
                }

            }
        }
    }

    public function createEscalationMatrix($data)
    {
        $escalation = $this->getEscalationExists($data);
        if ($escalation && count($escalation) > 0) {
            foreach ($escalation as $row) {
                $level = new EscalationMatrixLevels();
                $level->escalation_reference_id = $row->id;
                $level->name = $data->awcName;
                $level->level = $data->level;
                $level->mobile = $data->mobile;
                $level->days = $data->days;
                $level->district = $data->districtName;
                $level->resolving_officer = $data->resolveLevel;
                $level->save();
            }

        } else {
            Log::info('escalation id not found ' . json_encode($data));
        }
    }

    public function getEscalationExists($data)
    {
        $escalation = EscalationMatrix::where('scheme_id', $data->scheme)
            ->where('program_id', $data->program)
            ->where('district_id', $data->district)
            ->where('block_id', $data->block)
            ->get();

        if ($escalation && count($escalation) > 0) {
            return $escalation;
        }

        //create new escalation
        // $escalation = new EscalationMatrix();
        // $escalation->scheme_id = $data->scheme;
        // $escalation->program_id = $data->program;
        // $escalation->district_id = $data->district;
        // $escalation->block_id = $data->block;
        // $escalation->awc_id = $data->awc;
        // $escalation->save();

        // $escalationCol = new Collection();
        // $newData = new AppClass();
        // $newData->id = $escalation->id;
        // $escalationCol->add($newData);
        // return $escalationCol;
    }

}
