<?php

namespace App\Imports;

use App\Models\CustomerCoupons;
use App\Services\CommonService;
use App\Services\Transactions\SendCouponCodeService;
use Carbon\Carbon;
use Illuminate\Support\Collection;
use Maatwebsite\Excel\Concerns\ToCollection;
use stdClass;
use Log;

class ResendCouponCodes implements ToCollection
{
    /**
     * @param Collection $collection
     */

    public $rows;
    public $commonService;
    public $sendCouponCodeService;

    public function __construct(CommonService $commonService, SendCouponCodeService $sendCouponCodeService)
    {
        $this->commonService = $commonService;
        $this->sendCouponCodeService = $sendCouponCodeService;
    }

    public function collection(Collection $collection)
    {
        $this->rows = $collection;
        if ($this->rows->isNotEmpty()) {
            $this->processData();
        }
    }

    function processData()
    {

        $campaignValidity = Carbon::now()->addDays(7)->format('d/m/Y');

        foreach ($this->rows as $key => $row) {
            if ($key > 0) {
                $mobile = $this->commonService->formatMobileNo(trim($row[1]));
                $msgId = trim($row[2]);
                if ($mobile && $msgId) {
                    $coupons = CustomerCoupons::select('customer_coupons.coupon_amount', 'customer_coupons.coupon_code', 'customer_coupons.sales_id', 'sales.customer_name')
                        ->join('sales', 'sales.id', 'customer_coupons.sales_id')
                        ->where('sales.mobile', 'like', '%' . $mobile . '%')
                        ->where('customer_coupons.message_id', $msgId)
                        ->get();

                    if ($coupons->count() > 0) {

                        $waParam = new stdClass;
                        $waParam->mobile = $mobile;

                        $waParam->validity = $campaignValidity;

                        foreach ($coupons as $coupon) {
                            $waParam->name = $coupon->customer_name;
                            if ($coupon->coupon_amount == 1000) {
                                $waParam->voucherCode1 = $coupon->coupon_code;
                            }
                            if ($coupon->coupon_amount == 2000) {
                                $waParam->voucherCode2 = $coupon->coupon_code;
                            }
                            if ($coupon->coupon_amount == 3000) {
                                $waParam->voucherCode3 = $coupon->coupon_code;
                            }
                        }

                        if (isset($waParam->voucherCode1) && isset($waParam->voucherCode2) && isset($waParam->voucherCode3)) {
                            $response = $this->sendCouponCodeService->sendReferralCoupon($waParam);
                            $decode = json_decode($response, true);
                            if (isset($decode['status']) && $decode['status'] == 'submitted') {
                                $messageId = isset($decode['messageId']) ? $decode['messageId'] : null;
                                CustomerCoupons::where('sales_id', $coupon->sales_id)->update(['message_id' => $messageId]);
                            }
                        } else {
                            Log::info('voucher code missing . ' . json_encode($coupons));
                        }
                    } else {
                        Log::info('coupon codes not found for this mobile number . ' . $mobile);
                    }
                }
            }
        }
    }
}
