<?php

namespace App\Imports;

use App\Models\Masters\AwcMaster;
use App\Models\Masters\BlockMaster;
use App\Models\Masters\CityMaster;
use App\Models\Masters\EscalationMatrix;
use App\Models\Masters\EscalationMatrixLevels;
use App\Models\Masters\SectorMaster;
use App\Models\Transactions\BeneficiaryImport;
use App\Utilities\AppClass;
use Illuminate\Support\Collection;
use DB;
use Log;
use Maatwebsite\Excel\Concerns\ToCollection;

class UpdateCodes implements ToCollection
{
    public $rows;

    public function __construct()
    {
    }

    public function collection(Collection $collection)
    {
        $this->rows = $collection;
        if (count($this->rows) > 0) {
            $this->processData();
        }
    }

    public function processData()
    {

        $rows = $this->rows;

        //get district data
        // $data = $this->formatDistrictData($rows);
        // $this->updateDistrictData($data);

        //block data
        // $data = $this->formatBlockData($rows);
        // $this->updateBlockData($data);

        //sector data
        // $data = $this->formatSectorData($rows);
        // $this->updateSectorData($data);

        //AWC data
        // $data = $this->formatAWCData($rows);
        // $this->updateAWCData($data);

        //missing AWC
        // $data = $this->addMissingAwc($rows);

        //update wrong awc
        $data = $this->updateWrongAWC($rows);
    }

    public function updateWrongAWC($rows)
    {

        foreach ($rows as $key => $awcRow) {


            if ($key > 0 && $awcRow[11] != '' && $awcRow[11] != null) {
                // dd($awcRow);
                // echo $key . ' updated <br>';
                $awcDetails = DB::table('awc_master')->where('code', trim($awcRow[11]))->first();

                if ($awcDetails) {
                    // $beneficiary = DB::table('beneficiary_import')->where('mobile_number', trim($awcRow[2]))->first();

                    // if ($beneficiary) {
                    DB::table('beneficiary_import')->where('mobile_number', trim($awcRow[3]))->update([
                        'district_id' => $awcDetails->district_id,
                        'block_id' => $awcDetails->block_id,
                        'sector' => $awcDetails->sector_id,
                        'awc' => $awcDetails->id
                    ]);
                    // } else {
                    //     dd('beneficiary not found : ' . $awcRow[2]);
                    // }
                } else {
                    dd('awc not found : ' . $awcRow[11]);
                }
            }
        }
    }

    public function addMissingAwc($rows)
    {
        foreach ($rows as $key => $awcRow) {
            if ($key > 0) {
                $awc = AwcMaster::where('code', trim($awcRow[2]))->count();
                Log::info('code : ' . trim($awcRow[2]));
                if ($awc == 0) {
                    $sector = SectorMaster::where('code', trim($awcRow[0]))->first();
                    if ($sector) {
                        $awcMaster = new AwcMaster();
                        $awcMaster->district_id = $sector->district_id;
                        $awcMaster->block_id = $sector->block_id;
                        $awcMaster->sector_id = $sector->id;
                        $awcMaster->name = trim($awcRow[1]);
                        $awcMaster->code = trim($awcRow[2]);
                        $awcMaster->save();
                    } else {
                        dd('sector not found' . $awcRow[0]);
                    }
                }
            }
        }
    }

    public function formatAWCData($rows)
    {
        $awc = new Collection();
        foreach ($rows as $key => $data) {
            if ($key > 0) {
                $obj = new AppClass();
                $obj->name = trim($data[4]);
                $obj->districtCode = trim($data[0]);
                $obj->blockCode = trim($data[1]);
                $obj->sectorCode = trim($data[3]);
                $obj->code = trim($data[5]);
                $awc->add($obj);
            }
        }
        return $awc;
    }

    public function updateAWCData($rows)
    {

        foreach ($rows as $data) {
            if ($data->name != '' && $data->name != null) {
                $sector = DB::table('awc_master')
                    ->join('city_master', 'awc_master.district_id', 'city_master.id')
                    ->join('block_master', 'block_master.id', 'awc_master.block_id')
                    ->join('sector_master', 'sector_master.id', 'awc_master.sector_id')
                    ->where('awc_master.name', $data->name)
                    ->where('city_master.code', $data->districtCode)
                    ->where('block_master.code', $data->blockCode)
                    ->where('sector_master.code', $data->sectorCode)
                    ->select('awc_master.*')
                    ->first();
                if ($sector) {
                    DB::table('awc_master')->where('id', $sector->id)->update(['code' => $data->code]);
                } else {
                    Log::info('awc not found name : ' . $data->name . ' code: ' . $data->code);
                    $district = CityMaster::where('code', $data->districtCode)->first();
                    if ($district) {
                        $block = BlockMaster::where('code', $data->blockCode)->first();
                        if ($block) {
                            if ($data->sectorCode != '' && $data->sectorCode != null) {

                                $sector = SectorMaster::where('code', $data->sectorCode)->first();
                                if ($sector) {
                                    $new = new AwcMaster();
                                    $new->district_id = $district->id;
                                    $new->block_id = $block->id;
                                    $new->sector_id = $sector->id;
                                    $new->name = $data->name;
                                    $new->code = $data->code;
                                    $new->save();
                                } else {
                                    dd('sector not found : ', $data->sectorCode);
                                }
                            }
                        } else {
                            dd('block not found : ', $data->blockCode);
                        }
                    } else {
                        dd('district not found : ', $data->districtCode);
                    }
                }
            }
        }
    }


    public function formatSectorData($rows)
    {
        $sector = new Collection();
        foreach ($rows as $key => $data) {
            if ($key > 0) {
                if (!$sector->contains('code', trim($data[3]))) {
                    $obj = new AppClass();
                    $obj->name = trim($data[2]);
                    $obj->districtCode = trim($data[0]);
                    $obj->blockCode = trim($data[1]);
                    $obj->code = trim($data[3]);
                    $sector->add($obj);
                }
            }
        }
        return $sector;
    }

    public function updateSectorData($rows)
    {

        foreach ($rows as $data) {
            if ($data->name) {
                $sector = DB::table('sector_master')
                    ->join('city_master', 'sector_master.district_id', 'city_master.id')
                    ->join('block_master', 'block_master.id', 'sector_master.block_id')
                    ->where('sector_master.name', $data->name)
                    ->where('city_master.code', $data->districtCode)
                    ->where('block_master.code', $data->blockCode)
                    ->select('sector_master.*')
                    ->first();
                if ($sector) {
                    DB::table('sector_master')->where('id', $sector->id)->update(['code' => $data->code]);
                } else {
                    // dd('sector not found : ' . $data->name, $data->code);
                    Log::info('sector not found name : ' . $data->name . ' code: ' . $data->code);
                    $district = CityMaster::where('code', $data->districtCode)->first();
                    if ($district) {
                        $block = BlockMaster::where('code', $data->blockCode)->first();
                        if ($block) {
                            $new = new SectorMaster();
                            $new->district_id = $district->id;
                            $new->block_id = $block->id;
                            $new->name = $data->name;
                            $new->code = $data->code;
                            $new->save();
                        } else {
                            dd('block not found : ', $data->blockCode);
                        }
                    } else {
                        dd('district not found : ', $data->districtCode);
                    }
                }
            }
        }
    }

    public function formatBlockData($rows)
    {
        $block = new Collection();
        foreach ($rows as $key => $data) {
            if ($key > 0) {
                if (!$block->contains('code', trim($data[3]))) {
                    $obj = new AppClass();
                    $obj->name = trim($data[2]);
                    $obj->districtCode = trim($data[1]);
                    $obj->code = trim($data[3]);
                    $block->add($obj);
                }
            }
        }
        return $block;
    }

    public function updateBlockData($rows)
    {

        foreach ($rows as $data) {
            if ($data->name) {
                $block = DB::table('block_master')
                    ->join('city_master', 'block_master.district_id', 'city_master.id')
                    ->where('block_master.name', $data->name)
                    ->where('city_master.code', $data->districtCode)
                    ->select('block_master.*')
                    ->first();
                if ($block) {
                    DB::table('block_master')->where('id', $block->id)->update(['code' => $data->code]);
                } else {
                    dd('block not found : ' . $data->name, $data->code);
                }
            }
        }
    }

    public function formatDistrictData($rows)
    {
        $district = new Collection();
        foreach ($rows as $key => $data) {
            if ($key > 0) {
                if (!$district->contains('code', trim($data[1]))) {
                    $obj = new AppClass();
                    $obj->name = trim($data[0]);
                    $obj->code = trim($data[1]);
                    $district->add($obj);
                }
            }
        }
        return $district;
    }

    public function updateDistrictData($rows)
    {

        foreach ($rows as $data) {
            if ($data->name) {
                $cityMaster = CityMaster::where('name', $data->name)->first();
                if ($cityMaster) {
                    $cityMaster->code = $data->code;
                    $cityMaster->save();
                } else {
                    dd('district not found : ' . $data->name);
                }
            }
        }
    }
}
