<?php

namespace App\Models\Masters;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class CallSkipReason extends Model
{
    use HasFactory;
    use SoftDeletes;

    protected $table = 'call_skip_reason';
    protected $primaryKey = 'id';

    const STATUS_ACTIVE = 1;
    const STATUS_INACTIVE = 0;

    const IS_ANSWERED = 1;
    const IS_NOT_ANSWERED = 0;
    const BOTH = 2;

    const REASON_CALL_BACK = 4;
    const REASON_CALL_ANOTHER_NUMBER = 6;
    const REASON_LATER_VISIT = 12;

}
