<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
class RoleMaster extends Model
{
    use HasFactory;
    use SoftDeletes;

    protected $table = 'role_master';
    protected $primaryKey = 'id';

    const STATUS_ACTIVE = 1;
    const STATUS_INACTIVE = 0;

    const ROLE_AGENT = 6;
    const ROLE_LEVEL_OFFICER = 7;
    const ROLE_ADMIN = 1;
    const ROLE_CLUSTER = 8;

    const COMPLAIN_RESOLVED_AUTHORITIES = [
        null,
        self::ROLE_LEVEL_OFFICER,
    ];

    const HIDDEN_ROLES = [
        self::ROLE_AGENT,
        self::ROLE_LEVEL_OFFICER,
        self::ROLE_CLUSTER
    ];

    const RECORDING_HIDDEN_ROLES = [8];

    const SHOW_ALL_FEEDBACK_ROLES = [
        self::ROLE_ADMIN,
    ];

    const ADMIN_DASHBOARD_ROLES = [
        self::ROLE_ADMIN,
    ];

    const RESOLVE_ROLES = [
        self::ROLE_ADMIN,
        self::ROLE_AGENT
    ];

    public static function getRoleActive($id = null)
    {
        $sql = RoleMaster::where('status', self::STATUS_ACTIVE);
        if ($id) {
            $sql->where('id', $id);
        }
        return $sql;

    }

}
