<?php

namespace App\Models\Transactions;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use DB;

class BeneficiaryImport extends Model
{
    use HasFactory;
    use SoftDeletes;

    protected $table = 'beneficiary_import';
    protected $primaryKey = 'id';

    protected $fillable = [
        'branch_id',
        'customer_name',
        'mobile_number',
        'invoice_date',
        'source',
        'excel_campaign_id'
    ];

    const STATUS_ACTIVE = 1;
    const STATUS_INACTIVE = 0;
    const STATUS_CALL_INITIATED = 2;
    const STATUS_CALL_FEEDBACK_DONE = 3;
    const STATUS_CALL_SKIPPED = 4;

    const IMPORT_TYPE_AUTO = 1;
    const IMPORT_TYPE_MANUAL = 2;
    const IMPORT_TYPE_WEB_APP = 3;

    const SKIP_REASON_CALLBACK = 4;
    const SKIP_REASON_MASTERDATA_CORRECTION = 9;
    const SKIP_REASON_CALL_DISCONNECTED = 10;
    const SKIP_REASON_CALL_ANOTHER_NUMBER = 6;
    const SKIP_REASON_NOT_ATTEND = 2;
    const SKIP_REASON_WRONG_NUMBER = 1;

    const IS_SHOW_PERCENTAGE = 50;

    const SOURCE_TYPE_EXCEL = 1;
    const SOURCE_TYPE_JUST_DIAL = 2;
    const SOURCE_TYPE_CRM = 3;
    const SOURCE_TYPE_SOCIAL_MEDIA = 4;
    const SOURCE_TYPE_SAP = 5;
    const SOURCE_TYPE_EXCEL_CAMPAIGN = 6;
    const SOURCE_TYPE_HAPPY_CALLS = 7;

    const SOURCE_TYPE_DROP_DOWN = [
        self::SOURCE_TYPE_EXCEL => 'Tele Calling',
        self::SOURCE_TYPE_JUST_DIAL => 'Just Dial',
        self::SOURCE_TYPE_CRM => 'CRM',
        self::SOURCE_TYPE_SOCIAL_MEDIA => 'Social Media',
        self::SOURCE_TYPE_SAP => 'SAP',
        self::SOURCE_TYPE_EXCEL_CAMPAIGN => 'Vendor Campaign',
        self::SOURCE_TYPE_HAPPY_CALLS => 'Happy Calls',
    ];

    public static function getSourceCaseQuery()
    {
        $caseStatement = "CASE ";
        foreach (self::SOURCE_TYPE_DROP_DOWN as $key => $value) {
            $caseStatement .= "WHEN beneficiary_import.source = $key THEN '$value' ";
        }
        $caseStatement .= "ELSE 'N/A' END";
        return DB::raw("($caseStatement) as source");
    }
}
