<?php

namespace App\Models\Transactions;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class CallHistory extends Model
{
    use HasFactory;
    use SoftDeletes;

    protected $table = 'call_history';
    protected $primaryKey = 'id';

    const STATUS_ACTIVE = 1;
    const STATUS_INACTIVE = 0;
    const SCREEN_CALL_HISTORY = 'call history';

    protected $fillable = [
        'call_no',
        'type',
        'customer_number',
        'called_number',
        'agent_number',
        'call_status',
        'call_transfer_status',
        'customer_status',
        'agent_status',
        'call_uuid',
        'recording_url',
        'call_timestamp',
        'call_duration',
        'call_hang_up_by',
    ];

}
