<?php

namespace App\Models;

// use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;

class User extends Authenticatable implements MustVerifyEmail
{
    use HasApiTokens, HasFactory, Notifiable;
    use SoftDeletes;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'name',
        'email',
        'password',
        'role',
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];

    const STATUS_ACTIVE = 1;
    const STATUS_INACTIVE = 0;

    const USER_STATUS_UPDATE_TABLES = ['agent_master', 'user_master', 'cluster_master'];

    const LOGGED_USER_SUPER_ADMIN = 'superAdmin';
    const LOGGED_USER_APP_USER = 'appUser';

    const USER_TYPE_APP_USERS = 1;
    const USER_TYPE_AGENT = 2;
    const USER_TYPE_LEVEL_OFFICER = 3;

    const USER_TYPE_CLUSTER = 3;
}
