<?php

namespace App\Services;

// use Symfony\Component\Process\Process;

use App\Models\AudioAnalytics;
use App\Models\Transactions\CallHistory;
use Illuminate\Support\Facades\Log;
use DB;

class AudioScriptAnalysisService
{
    // public function fetchData()
    // {
    //     $audioFilePath = storage_path('app/public/sample.mp3');

    //     if (!file_exists($audioFilePath)) {
    //         throw new \Exception("Audio file not found at: $audioFilePath");
    //     }

    //     try {
    //         $output = $this->transcribeWithWhisper($audioFilePath);
    //         dd($output);
    //         return $output;
    //     } catch (\Exception $e) {
    //         dd($e->getMessage());
    //         Log::error("Error in fetchData: " . $e->getMessage());
    //         return null;
    //     }
    // }

    // private function transcribeWithWhisper($audioFilePath)
    // {
    //     $process = new Process(['whisper', $audioFilePath, '--language', 'en', '--model', 'base']);
    //     Log::info("Command: " . $process->getCommandLine());
    //     $process->run();

    //     if (!$process->isSuccessful()) {
    //         throw new \RuntimeException("Whisper Error: " . $process->getErrorOutput());
    //     }

    //     return $process->getOutput();
    // }

    public function fetchData()
    {
        DB::table('call_history')->select('id', 'process_response')
            ->whereNull('audio_process')
            ->where('process', 'completed')
            ->orderBy('id')
            ->chunk(500, function ($records) {
                foreach ($records as $record) {
                    $transcript = json_decode($record->process_response);

                    if (json_last_error() !== JSON_ERROR_NONE || !isset($transcript->script_coverage)) {
                        Log::warning("Invalid JSON or missing coverage for call ID {$record->id}");
                        continue;
                    }

                    foreach ($transcript->script_coverage->sections as $key => $script) {
                        AudioAnalytics::create([
                            'call_id' => $record->id,
                            'name' => $key,
                            'value' => $script->covered ?? null
                        ]);
                    }

                    $processUpdate = array(
                        'audio_process' => 1,
                        'sections_covered' => $transcript->script_coverage->overall_coverage->sections_covered ?? null,
                        'sections_partially_covered' => $transcript->script_coverage->overall_coverage->sections_partially_covered ?? null,
                        'sections_missed' => $transcript->script_coverage->overall_coverage->sections_missed ?? null,
                    );
                    CallHistory::where('id', $record->id)->update($processUpdate);
                }
            });
    }
}
