<?php

namespace App\Services\CRM\Masters;

use App\Models\CRM\Masters\RequestCategory;
use Illuminate\Http\Request;
use Auth;

class RequestCategoryService
{

    public function __construct() {}

    public function getData()
    {
        $sql = RequestCategory::orderBy('id', 'desc');
        return $sql;
    }

    public function isNew($id = null)
    {
        if ($id) {
            $id = decrypt($id);
            $data = RequestCategory::find($id);
            $data->route = route('request-category.update', $id);
            $data->method = 'PUT';
            $data->breadcrumbName = 'Edit';
        } else {
            $data = new RequestCategory();
            $data->route = route('request-category.store');
            $data->method = 'POST';
            $data->breadcrumbName = 'Create';
        }
        $data->breadcrumbAction = route('request-category.index');
        $data->breadcrumbTitle = 'Request Category';
        return $data;
    }

    public function saveData(Request $request, $id = null)
    {
        $name = $request->has('name') ? $request->get('name') : '';
        $description = $request->has('description') ? $request->get('description') : '';

        if ($id) {
            $data = RequestCategory::find($id);
            $data->updated_by = Auth::user()->id;
        } else {
            $data = new RequestCategory();
            $data->created_by = Auth::user()->id;
            $data->updated_by = Auth::user()->id;
        }

        $data->name = $name;
        $data->description = $description;
        if ($data->save()) {
            return true;
        }
    }

    public function showData($id)
    {
        return RequestCategory::find($id);
    }
}
