<?php

namespace App\Services\CRM\Masters;

use App\Models\CRM\Masters\TicketSource;
use Illuminate\Http\Request;
use Auth;

class TicketSourceService
{

    public function __construct() {}

    public function getData()
    {
        $sql = TicketSource::orderBy('id', 'desc');
        return $sql;
    }

    public function isNew($id = null)
    {
        if ($id) {
            $id = decrypt($id);
            $data = TicketSource::find($id);
            $data->route = route('ticket-source.update', $id);
            $data->method = 'PUT';
            $data->breadcrumbName = 'Edit';
        } else {
            $data = new TicketSource();
            $data->route = route('ticket-source.store');
            $data->method = 'POST';
            $data->breadcrumbName = 'Create';
        }
        $data->breadcrumbAction = route('ticket-source.index');
        $data->breadcrumbTitle = 'Ticket Source';
        return $data;
    }

    public function saveData(Request $request, $id = null)
    {
        $name = $request->has('name') ? $request->get('name') : '';
        $description = $request->has('description') ? $request->get('description') : '';

        if ($id) {
            $data = TicketSource::find($id);
            $data->updated_by = Auth::user()->id;
        } else {
            $data = new TicketSource();
            $data->created_by = Auth::user()->id;
            $data->updated_by = Auth::user()->id;
        }

        $data->name = $name;
        $data->description = $description;
        if ($data->save()) {
            return true;
        }
    }

}
