<?php

namespace App\Services;

use App\Models\CRMTickets;
use App\Models\Masters\AgentMaster;
use App\Models\Masters\BranchMaster;
use App\Models\Transactions\BeneficiaryImport;
use App\Models\User;
use Illuminate\Http\Request;
use Log;
use DB;
use stdClass;

class CRMTicketService
{
    private $commonService;

    public function __construct(CommonService $commonService)
    {
        $this->commonService = $commonService;
    }

    function addCRMTicket(Request $request)
    {

        $response = new stdClass;
        $response->status = false;
        $response->msg = 'Failed to create ticket';
        try {
            DB::beginTransaction();
            Log::info('addCRMTicket request : ' . json_encode($request->all()));

            $branch = BranchMaster::select('id')->where('crm_code', $request->branch)->first();

            //save leads to table
            $leads = new CRMTickets();
            $leads->mobile = isset($request->mobile) ? $request->mobile : null;
            $leads->customer_name = isset($request->customerName) ? $request->customerName : null;
            $leads->email = isset($request->email) ? $request->email : null;
            $leads->location = isset($request->location) ? $request->location : null;
            $leads->product_enquiry = isset($request->productEnquiry) ? $request->productEnquiry : null;
            $leads->branch = isset($request->branch) ? $request->branch : null;
            $leads->branch_id = isset($branch->id) ? $branch->id : null;
            $leads->department = isset($request->department) ? $request->department : null;
            $leads->ticket_category = isset($request->ticketCategory) ? $request->ticketCategory : null;
            $leads->users = isset($request->users) ? $request->users : null;
            $leads->ticket_source = isset($request->ticketSource) ? $request->ticketSource : null;
            $leads->ticket_type = isset($request->ticketType) ? $request->ticketType : null;
            $leads->priority = isset($request->priority) ? $request->priority : null;
            $leads->expected_date = isset($request->expectedDate) ? $request->expectedDate : null;
            $leads->expected_price = isset($request->expectedPrice) ? $request->expectedPrice : null;
            $leads->offer_price = isset($request->offerPrice) ? $request->offerPrice : null;
            $leads->ticket_comment = isset($request->ticketComment) ? $request->ticketComment : null;
            if ($leads->save()) {

                $id = $leads->id;
                $customer = new BeneficiaryImport();
                $customer->branch_id = isset($branch->id) ? $branch->id : null;
                $customer->customer_name = isset($request->customerName) ? $request->customerName : null;
                $customer->mobile_number = isset($request->mobile) ? $request->mobile : null;
                $customer->description = isset($request->productEnquiry) ? $request->productEnquiry : null;
                $customer->crm_lead_id = $id;
                $customer->source = BeneficiaryImport::SOURCE_TYPE_CRM;
                $customer->save();
                if ($leads->branch_id) {
                    $this->sendOnesignalCRMNotification($leads);
                }
                $response->status = true;
                $response->msg = 'Ticket Created Successfully';
            }
            DB::commit();
            return response()->json($response);
        } catch (\Exception $e) {
            DB::rollback();
            Log::info('addCRMTicket dial error : ' . $e->getMessage());
            return response()->json($response);
        }
    }

    function sendOnesignalCRMNotification($leads)
    {
        $playerIds = User::select('users.player_id')
            ->join('agent_master', 'agent_master.id', 'users.reference_id')
            ->where('agent_master.status', AgentMaster::STATUS_ACTIVE)
            ->where('users.user_type', User::USER_TYPE_AGENT)
            ->where('agent_master.branch_id', $leads->branch_id)
            ->where('agent_master.crm_lead_assign', 1)
            ->where('users.player_id', '!=', 'null')
            ->whereNotNull('users.player_id')
            ->pluck('player_id');
        if (count($playerIds) > 0) {
            $url = 'https://api.onesignal.com/notifications?c=push';
            $bodyParams = array(
                'app_id' => constants('ONE_SIGNAL_APP_ID'),
                'contents' => array('en' => 'You have received new lead from crm...'),
                'headings' => array('en' => 'CRM Ticket Notification'),
                'include_player_ids' => $playerIds
            );
            $response = $this->commonService->coreGuzzlePostOneSignal($url, $bodyParams);
            Log::info('One signal response : ' . json_encode($response));
            if ($response->status == 200 && isset($response->data->id) && $response->data->id) {
                Log::info('One signal notification sent crm');
            }
        }
    }
}
