<?php

namespace App\Services;

use App\Models\EmployeewiseAttendance;
use App\Models\Feedback;
use App\Models\Masters\AgentMaster;
use App\Models\OverallAttendance;
use App\Models\Transactions\BeneficiaryImport;
use App\Models\Transactions\CallHistory;
use Illuminate\Http\Request;
use Log;
use DB;
use PDO;
use stdClass;

class CallHistoryService
{
    private $commonService;

    public function __construct(CommonService $commonService)
    {
        $this->commonService = $commonService;
    }

    function pushCallLog(Request $request)
    {
        $response = new stdClass;
        $response->status = "failure";
        $response->call_status = "Invalid Parameters";

        try {
            DB::beginTransaction();
            Log::info('pushCallLog request : ' . json_encode($request->all()));

            $callNo = $this->commonService->generateUniqueScreenNumber(CallHistory::SCREEN_CALL_HISTORY);

            // $recording = null;
            // if ($request->file('call_recording')) {
            //     $file = $request->file('call_recording');
            //     $fileName = $file->getClientOriginalName();
            //     $recording = $fileName;
            //     $name = explode('.', $fileName);
            //     $fileName = $name[0] . '_' . time() . '.' . $file->extension();
            //     $file->move(storage_path('uploads/recordings'), $fileName);
            // }
            $agentNumber = $this->commonService->formatMobileNo($request->agent_number);
            $agent = AgentMaster::where('phone', $agentNumber)->first();
            if (isset($agent->id) && $agent->id) {
                $customerNumber = $this->commonService->formatMobileNo($request->agent_list);
                $customer = BeneficiaryImport::where('mobile_number', $customerNumber)->where('agent_id', $agent->id)->first();
            }

            //update recoeding to feedback table
            // if (isset($customer->id) && $customer->id && isset($agent->id) && $agent->id) {
            //     $feedback = Feedback::where('created_by', $agent->id)->where('beneficiary_ref_id', $customer->id)->orderBy('id','desc')->first();
            //     if ($feedback) {
            //         $feedback->recordings = isset($request->call_recording) ? $request->call_recording : null;
            //         $feedback->save();
            //     }
            // }

            $log = new CallHistory();
            $log->call_no = $callNo;
            $log->call_date = isset($request->call_date) ? $request->call_date : null;
            $log->call_time = isset($request->call_time) ? $request->call_time : null;
            $log->call_direction = isset($request->call_direction) ? $request->call_direction : null;
            $log->customer_number = isset($request->agent_list) ? $request->agent_list : null;
            $log->called_number = isset($request->called_number) ? $request->called_number : null;
            $log->call_duration = isset($request->call_duration) ? $request->call_duration : null;
            $log->call_transfer_duration = isset($request->call_transfer_duration) ? $request->call_transfer_duration : null;
            $log->call_uuid = isset($request->call_uuid) ? $request->call_uuid : null;
            $log->call_status = isset($request->call_status) ? $request->call_status : null;
            $log->call_transfer_status = isset($request->call_transfer_status) ? $request->call_transfer_status : null;
            $log->agent_list = isset($request->agent_list) ? $request->agent_list : null;
            $log->agent_number = isset($request->agent_number) ? $request->agent_number : null;
            $log->menu = isset($request->menu) ? $request->menu : null;
            $log->call_recording = isset($request->call_recording) ? $request->call_recording : null;
            $log->agent_id = isset($agent->id) ? $agent->id : null;
            $log->customer_id = isset($customer->id) ? $customer->id : null;

            if ($log->save()) {
                $response->request_id = $callNo;
                $response->status = "success";
                $response->call_status = "Call log created successfully";
            }
            DB::commit();
            return response()->json($response);
        } catch (\Exception $e) {
            DB::rollback();
            Log::info('pushCallLog error : ' . $e->getMessage());
            return response()->json($response);
        }
    }

    function employeewiseAttendance(Request $request)
    {
        Log::info('employeewiseAttendence request : ' . json_encode($request->all()));
        $data = $request->data;
        $saved = false;
        foreach ($data as $row) {
            $attendance = new EmployeewiseAttendance();
            $attendance->date = isset($row['date']) ? $row['date'] : null;
            $attendance->emp_code = isset($row['empCode']) ? $row['empCode'] : null;
            $attendance->branch_code = isset($row['branchCode']) ? $row['branchCode'] : null;
            $attendance->status = isset($row['status']) ? $row['status'] : null;
            if ($attendance->save()) {
                $saved = true;
            }
        }
        if ($saved) {
            $data = new stdClass;
            return $this->commonService->makeSuccessResponse('attendance saved successfully', $data);
        }
        return $this->commonService->makeErrorResponse('failed to save.');
    }

    function overallAttendance(Request $request)
    {
        Log::info('overallAttendance request : ' . json_encode($request->all()));
        $data = $request->data;
        $saved = false;
        foreach ($data as $row) {
            $attendance = new OverallAttendance();
            $attendance->date = isset($row['date']) ? $row['date'] : null;
            $attendance->branch_code = isset($row['branchCode']) ? $row['branchCode'] : null;
            $attendance->present = isset($row['present']) ? $row['present'] : null;
            if ($attendance->save()) {
                $saved = true;
            }
        }
        if ($saved) {
            $data = new stdClass;
            return $this->commonService->makeSuccessResponse('attendance saved successfully', $data);
        }
        return $this->commonService->makeErrorResponse('failed to save.');
    }
}
