<?php

namespace App\Services;

use App\Models\Masters\CallSkipReason;
use App\Models\Masters\Campaign;
use Illuminate\Http\Request as HttpRequest;
use Auth;
use DB;

class CallReasonService
{

    private $commonService;

    public function __construct(CommonService $commonService)
    {
        $this->commonService = $commonService;
    }

    public function getData()
    {
        $data = CallSkipReason::select(
            '*',
            DB::raw('(CASE WHEN is_answered = 1 THEN "Connected" WHEN is_answered = 2 THEN "Both" ELSE "Not Connected" END) as callType')
        )
            ->orderBy('id', 'desc')
            ->get(); // If you want to get the results immediately

        return $data;
    }

    public function isNew($id = null)
    {
        if ($id) {
            $id = decrypt($id);
            $data = CallSkipReason::find($id);
            $data->route = route('call-reasons.update', $id);
            $data->method = 'PUT';
            $data->breadcrumbName = 'Edit';
        } else {
            $data = new CallSkipReason();
            $data->route = route('call-reasons.store');
            $data->method = 'POST';
            $data->breadcrumbName = 'Call Reason';
        }

        $data->breadcrumbAction = route('call-reasons.index');
        $data->breadcrumbTitle = 'Call Reason';
        return $data;
    }

    public function saveData(HttpRequest $request, $id = null)
    {
        $name = $request->has('name') ? $request->get('name') : '';
        $type = $request->has('type') ? $request->get('type') : '';
        $dispositions = $request->has('dispositions') ? $request->get('dispositions') : '';

        if ($id) {
            $data = CallSkipReason::find($id);
            $data->updated_by = Auth::user()->id;
        } else {
            $data = new CallSkipReason();
            $data->created_by = Auth::user()->id;
        }
        $data->name = $name;
        $data->is_answered = $type;
        $data->dispositions = $dispositions;
        $data->save();

        if ($data) {
            return true;
        }
    }

    function show($id)
    {
        $data = Campaign::select('campaign.*', 'branch_master.name as branchName')
            ->join('branch_master', 'branch_master.id', 'campaign.branch_id')
            ->where('campaign.id', $id)
            ->first();
        return $data;
    }
}
