<?php

namespace App\Services;

use App\Utilities\AppClass;

class FormService
{

    const ARRAY_FORM_FIELDS = ['checkbox-group', 'file', 'select', 'radio-group'];

    public function __construct()
    {

    }

    public function deviationCheckBox($jsonContent, $type)
    {
        if ($type != 'feedback') {
            return '';
        }
        $html = '<div class="col-lg-12">
                    <label class="ckbox"><input type="checkbox" name="deviation" class="deviationCheckbox" data-name="' . isElementHasValue($jsonContent, "name") . '" data-label="' . isElementHasValue($jsonContent, "label") . '" data-type="' . isElementHasValue($jsonContent, "type") . '"><span>Deviation</span></label>
                </div>';
        return $html;
    }

    public function criticalPointsCheckBox($jsonContent, $type)
    {
        if ($type != 'critical-points') {
            return '';
        }

        $checked = '';
        if (isElementHasValue($jsonContent, "criticalPoint")) {
            $checked = 'checked';
        }

        $html = '<div class="col-lg-12">
                    <label class="ckbox"><input type="checkbox" name="criticalPoints[]" class="criticalPointsCheckbox" value="' . isElementHasValue($jsonContent, "name") . '" data-name="' . isElementHasValue($jsonContent, "name") . '" ' . $checked . ' data-label="' . isElementHasValue($jsonContent, "label") . '" data-type="' . isElementHasValue($jsonContent, "type") . '"><span>Critical Points</span></label>
                </div>';

        return $html;

    }

    public function makeHeaderElement($jsonContent, $type)
    {
        $html = '<div class="col-md-6"><' . isElementHasValue($jsonContent, "subtype") . '>' . isElementHasValue($jsonContent, "label") . '</' . isElementHasValue($jsonContent, "subtype") . '></div>';
        return $html;
    }

    public function makeCheckBoxGroupElement($jsonContent, $type)
    {

        $html = '<div class="col-md-6">';

        $html .= '<div class="deviation_checkbox_div">' . $this->deviationCheckBox($jsonContent, $type) . '</div>';

        $html .= '<div class="critical_points_div">' . $this->criticalPointsCheckBox($jsonContent, $type) . '</div>';

        $html .= '<p class="mg-b-10"><label class="form-label">' . isElementHasValue($jsonContent, "label");

        if (isElementHasValue($jsonContent, "required")) {

            $html .= '<span class="tx-danger">*</span>';
        }

        $html .= '</label></p>';

        $html .= '<div class="parsley-checkbox row" id="cbWrapper">';

        foreach ($jsonContent['values'] as $key => $values) {
            $html .= '<div class="col-xl-3">
                        <label class="ckbox mg-b-5-f"><input ';

            if ($type != 'critical-points' && $key == 0 && isElementHasValue($jsonContent, "required")) {
                $html .= 'data-parsley-class-handler="#cbWrapper" data-parsley-errors-container="#cbErrorContainer" data-parsley-mincheck="1" required=""';
            }

            $html .= 'name="checkbox-group_' . isElementHasValue($jsonContent, "name") . '[]" type="checkbox" value="' . isElementHasValue($values, "label") . '"><span>' . isElementHasValue($values, "value") . '</span></label>
                    </div>';
        }

        $html .= '</div><div id="cbErrorContainer"></div>';

        if (isElementHasValue($jsonContent, "other")) {
            $html .= '<div class="row"><div class="col-xl-12"> <label class="ckbox mg-b-5-f"><input class="other-options" data-field-id="other-checkbox-group_' . isElementHasValue($jsonContent, "name") . '" data-field-type="checkbox" name="checkbox-group_' . isElementHasValue($jsonContent, "name") . '[]" type="checkbox" value="Others"><span>Others</span></label> <textarea class="form-control d-none" id="other-checkbox-group_' . isElementHasValue($jsonContent, "name") . '" name="checkbox-group_' . isElementHasValue($jsonContent, "name") . '[]"></textarea> </div></div>';
        }

        $html .= '<span class="help-text">' . isElementHasValue($jsonContent, "description") . '</span></div>';
        return $html;

    }

    public function makeDateElement($jsonContent, $type)
    {

        $html = '<div class="col-md-6">';
        $html .= '<div class="deviation_checkbox_div">' . $this->deviationCheckBox($jsonContent, $type) . '</div>';
        // $html .= '<div class="critical_points_div">' . $this->criticalPointsCheckBox($jsonContent, $type) . '</div>';
        $html .= '<label class="form-label">' . isElementHasValue($jsonContent, "label") . '';
        if (isElementHasValue($jsonContent, "required")) {
            $html .= '<span class="text-danger">*</span>';
        }

        $html .= '</label>
					<div class="mg-b-20">
						<div class="input-group">
							<div class="input-group-prepend">
								<div class="input-group-text">
									<i class="fe fe-calendar lh--9 op-6"></i>
								</div>
							</div><input class="form-control fc-datepicker-custom" placeholder="MM/DD/YYYY" type="text" name="date_' . isElementHasValue($jsonContent, "name") . '"';
        if ($type != 'critical-points' && isElementHasValue($jsonContent, "required")) {
            $html .= 'required="" ';
        }
        $html .= '>';
        $html .= '</div>
						</div><span class="help-text">' . isElementHasValue($jsonContent, "description") . '</span>
					</div>';

        return $html;
    }

    public function makeFileElement($jsonContent, $type)
    {
        $html = '<div class="col-md-6">';
        // $html .= '<div class="deviation_checkbox_div">' . $this->deviationCheckBox($jsonContent, $type) . '</div>';
        $html .= '<div class="form-group">
                    <label class="form-label">' . isElementHasValue($jsonContent, "label") . '';

        if (isElementHasValue($jsonContent, "required")) {
            $html .= '<span class="text-danger">*</span>';
        }

        $html .= '</label>
                    <div class="input-group file-browser">
                        <input type="text"
                            class="form-control border-right-0 browse-file"
                            placeholder="Browse" readonly>
                        <label class="input-group-btn">
                            <span class="btn btn-primary">
                                Browse <input type="file" name="file_' . isElementHasValue($jsonContent, "name") . '[]" style="display: none;" multiple ';
        if ($type != 'critical-points' && isElementHasValue($jsonContent, "required")) {
            $html .= 'required="" ';
        }
        $html .= '>';
        $html .= '</span>
                        </label>
                    </div>
                </div><span class="help-text">' . isElementHasValue($jsonContent, "description") . '</span>
        </div>';

        return $html;
    }

    public function makeNumberElement($jsonContent, $type)
    {
        $html = '<div class="col-md-6">';

        $html .= '<div class="deviation_checkbox_div">' . $this->deviationCheckBox($jsonContent, $type) . '</div>';
        // $html .= '<div class="critical_points_div">' . $this->criticalPointsCheckBox($jsonContent, $type) . '</div>';
        $html .= '<div class="form-group">
                <p class="mg-b-10"><label class="form-label">
                ' . isElementHasValue($jsonContent, "label") . '';
        if (isElementHasValue($jsonContent, "required")) {
            $html .= '<span class="text-danger">*</span>';
        }
        $html .= '</label></p>
                <input type="number" step="any" class="form-control" placeholder="' . isElementHasValue($jsonContent, "placeholder") . '" name="number_' . isElementHasValue($jsonContent, "name") . '"';
        if ($type != 'critical-points' && isElementHasValue($jsonContent, "required")) {
            $html .= 'required="" ';
        }
        if ($type != 'critical-points' && isset($jsonContent['min'])) {
            $html .= 'data-parsley-minlength="' . isElementHasValue($jsonContent, "min") . '" ';
        }
        if ($type != 'critical-points' && isset($jsonContent['max'])) {
            $html .= 'data-parsley-maxlength="' . isElementHasValue($jsonContent, "max") . '"';
        }

        $html .= '></div><span class="help-text">' . isElementHasValue($jsonContent, "description") . '</span>
            </div>';
        return $html;
    }

    public function makeTextElement($jsonContent, $type)
    {
        $html = '<div class="col-md-6">';

        $html .= '<div class="deviation_checkbox_div">' . $this->deviationCheckBox($jsonContent, $type) . '</div>';
        // $html .= '<div class="critical_points_div">' . $this->criticalPointsCheckBox($jsonContent, $type) . '</div>';
        $html .= '<div class="form-group">
                <p class="mg-b-10"><label class="form-label">
                ' . isElementHasValue($jsonContent, "label") . '';
        if (isElementHasValue($jsonContent, "required")) {
            $html .= '<span class="text-danger">*</span>';
        }
        $html .= '</label></p>
                <input type="' . isElementHasValue($jsonContent, "subtype") . '" placeholder="' . isElementHasValue($jsonContent, "placeholder") . '" class="form-control" name="text_' . isElementHasValue($jsonContent, "name") . '" ';
        if ($type != 'critical-points' && isElementHasValue($jsonContent, "required")) {
            $html .= 'required="" ';
        }

        if ($type != 'critical-points' && isset($jsonContent['maxlength'])) {
            $html .= 'data-parsley-maxlength="' . isElementHasValue($jsonContent, "maxlength") . '"';
        }

        $html .= '></div><span class="help-text">' . isElementHasValue($jsonContent, "description") . '</span>
            </div>';
        return $html;
    }

    public function makeParagraphElement($jsonContent, $type)
    {
        return '<p>' . isElementHasValue($jsonContent, "label") . '</p>';
    }

    public function makeRadioElement($jsonContent, $type)
    {

        $html = '<div class="col-md-6">';

        $html .= '<div class="deviation_checkbox_div">' . $this->deviationCheckBox($jsonContent, $type) . '</div>';
        $html .= '<div class="critical_points_div">' . $this->criticalPointsCheckBox($jsonContent, $type) . '</div>';
        $html .= '<p><label class="form-label">' . isElementHasValue($jsonContent, "label") . '</label></p>';
        $html .= '<div class="col-lg-6 mg-t-20 mg-lg-t-0">';
        foreach ($jsonContent['values'] as $key => $values) {
            $html .= '<label class="rdiobox"><input ';
            if (isElementHasValue($values, "selected")) {
                $html .= 'checked';
            }
            if ($type != 'critical-points' && $key == 0 && isElementHasValue($jsonContent, "required")) {
                $html .= ' required="true"';
            }
            $html .= ' name="radio-group_' . isElementHasValue($jsonContent, "name") . '[]" class="radio-select" data-field-id="other-radio-group_' . isElementHasValue($jsonContent, "name") . '" type="radio" value="' . isElementHasValue($values, "label") . '"> <span>' . isElementHasValue($values, "value") . '</span></label>';
        }

        $html .= '</div>';

        if (isElementHasValue($jsonContent, "other")) {
            $html .= '<div class="row" style="margin-left: 15px"> <label class="rdiobox"><input class="other-options" data-field-id="other-radio-group_' . isElementHasValue($jsonContent, "name") . '" data-field-type="radio" name="radio-group_' . isElementHasValue($jsonContent, "name") . '[]" type="radio" value="Others"> <span>Others</span></label> <textarea class="form-control d-none" id="other-radio-group_' . isElementHasValue($jsonContent, "name") . '" name="radio-group_' . isElementHasValue($jsonContent, "name") . '[]"></textarea></div>';
        }

        $html .= '<span class="help-text">' . isElementHasValue($jsonContent, "description") . '</span>';

        $html .= '</div>';
        return $html;
    }

    public function makeSelectElement($jsonContent, $type)
    {
        $html = '<div class="col-md-6">';

        $html .= '<div class="deviation_checkbox_div">' . $this->deviationCheckBox($jsonContent, $type) . '</div>';
        $html .= '<div class="critical_points_div">' . $this->criticalPointsCheckBox($jsonContent, $type) . '</div>';
        $html .= '<div class="form-group">

                                            <label class="form-label">' . isElementHasValue($jsonContent, "label") . '</label>

                                            <div class="parsley-select">
                                                <select class="form-control select2 feedback-select2" name="select_' . isElementHasValue($jsonContent, "name") . '[]" ';

        if ($type != 'critical-points' && isElementHasValue($jsonContent, "required")) {
            $html .= 'required=""';
        }

        if (isElementHasValue($jsonContent, "multiple")) {
            $html .= 'multiple';
        }
        $html .= '>';
        $html .= '<option label="Select"></option>';
        foreach ($jsonContent['values'] as $values) {
            $html .= '<option value="' . isElementHasValue($values, "label") . '">' . isElementHasValue($values, "value") . '</option>';
        }

        $html .= '</select>
                                            </div>
                                        </div><span class="help-text">' . isElementHasValue($jsonContent, "description") . '</span>
                                        </div>';
        return $html;

    }

    public function makeTextareaElement($jsonContent, $type)
    {
        $html = '<div class="col-md-6">';
        $html .= '<div class="deviation_checkbox_div">' . $this->deviationCheckBox($jsonContent, $type) . '</div>';
        // $html .= '<div class="critical_points_div">' . $this->criticalPointsCheckBox($jsonContent, $type) . '</div>';
        $html .= '<label class="form-label">' . isElementHasValue($jsonContent, "label") . '';

        if (isElementHasValue($jsonContent, "required")) {
            $html .= '<span class="text-danger">*</span>';
        }

        $html .= '</label>';
        $html .= '<textarea class="form-control" name="textarea_' . isElementHasValue($jsonContent, "name") . '" placeholder="' . isElementHasValue($jsonContent, "placeholder") . '" rows="3" ';

        if ($type != 'critical-points' && isElementHasValue($jsonContent, "required")) {
            $html .= 'required=""';
        }
        $html .= '></textarea><span class="help-text">' . isElementHasValue($jsonContent, "description") . '</span>
                    </div>';
        return $html;
    }

    public function newFormObject()
    {
        $formObjects = new AppClass();
        $formObjects->label = null;
        $formObjects->name = null;
        $formObjects->value = null;
        $formObjects->isArray = false;
        $formObjects->isFile = false;
        $formObjects->type = 'normal';
        $formObjects->criticalPoint = 0;
        return $formObjects;
    }

    public function getMatchedJson($params)
    {
        $type = $params->typeOfForm;
        $jsonContent = $params->jsonContent;
        $name = $this->formNameToOriginalName($params->fieldName);

        foreach ($jsonContent as $json) {
            if ($type == $json['type'] && $json['name'] == $name) {
                return $json;
            }
        }

    }

    public function isArrayField($name)
    {
        if (in_array($name, self::ARRAY_FORM_FIELDS)) {
            return true;
        }
    }

    public function setFormFieldAttributes($params)
    {
        $formObjects = $this->newFormObject();
        $json = $this->getMatchedJson($params);
        $formObjects->isArray = $this->isArrayField($params->typeOfForm);
        $formObjects->othersValue = null;

        if ($params->typeOfForm == 'file') {
            $formObjects->isFile = true;
        }

        if ($json) {

            if (isset($json['other']) && $json['other']) {
                $removed = array_pop($params->formValue);
                $formObjects->othersValue = $removed;
            }

            $formObjects->label = $json['label'];
            $formObjects->name = $params->fieldName;
            $formObjects->value = $params->formValue;
        }

        if ($formObjects->isArray) {
            $formObjects->value = implode(', ', $params->formValue);
            $formObjects->type = 'array';
        }

        return $formObjects;
    }

    public function createFormFields($jsonContent, $type = null)
    {
        $html = '';
        $fieldType = $jsonContent['type'];
        switch ($fieldType) {
            case 'header':
                $html = $this->makeHeaderElement($jsonContent, $type);
                break;
            case 'checkbox-group':
                $html = $this->makeCheckBoxGroupElement($jsonContent, $type);
                break;
            case 'date':
                $html = $this->makeDateElement($jsonContent, $type);
                break;
            case 'file':
                $html = $this->makeFileElement($jsonContent, $type);
                break;
            case 'number':
                $html = $this->makeNumberElement($jsonContent, $type);
                break;
            case 'text':
                $html = $this->makeTextElement($jsonContent, $type);
                break;
            case 'paragraph':
                $html = $this->makeParagraphElement($jsonContent, $type);
                break;
            case 'radio-group':
                $html = $this->makeRadioElement($jsonContent, $type);
                break;
            case 'select':
                $html = $this->makeSelectElement($jsonContent, $type);
                break;
            case 'textarea':
                $html = $this->makeTextareaElement($jsonContent, $type);
                break;
        }
        return $html;
    }

    public function formNameToOriginalName($name)
    {
        $field = explode('_', $name);
        if (count($field) > 0) {
            return $field[1];
        }
    }

}
