<?php

namespace App\Services;

use App\Models\JustDialLeads;
use App\Models\Masters\BranchLeadsAssign;
use App\Models\Masters\BranchMaster;
use App\Models\Transactions\BeneficiaryImport;
use App\Models\User;
use Illuminate\Http\Request;
use Log;
use DB;
use stdClass;

class JustDialService
{
    private $commonService;

    public function __construct(CommonService $commonService)
    {
        $this->commonService = $commonService;
    }

    function addLeads(Request $request)
    {

        $response = new stdClass;
        $response->status = 'FAILED';
        try {
            DB::beginTransaction();
            Log::info('addLeads just dial request : ' . json_encode($request->all()));

            $branch = BranchMaster::select('id')->where('justdial_code', $request->parentid)->first();

            //save leads to table
            $leads = new JustDialLeads();
            $leads->leadid = isset($request->leadid) ? $request->leadid : null;
            $leads->leadtype = isset($request->leadtype) ? $request->leadtype : null;
            $leads->prefix = isset($request->prefix) ? $request->prefix : null;
            $leads->name = isset($request->name) ? $request->name : null;
            $leads->mobile = isset($request->mobile) ? $request->mobile : null;
            $leads->phone = isset($request->phone) ? $request->phone : null;
            $leads->email = isset($request->email) ? $request->email : null;
            $leads->date = isset($request->date) ? $request->date : null;
            $leads->category = isset($request->category) ? $request->category : null;
            $leads->area = isset($request->area) ? $request->area : null;
            $leads->city = isset($request->city) ? $request->city : null;
            $leads->brancharea = isset($request->brancharea) ? $request->brancharea : null;
            $leads->dncmobile = isset($request->dncmobile) ? $request->dncmobile : null;
            $leads->dncphone = isset($request->dncphone) ? $request->dncphone : null;
            $leads->company = isset($request->company) ? $request->company : null;
            $leads->pincode = isset($request->pincode) ? $request->pincode : null;
            $leads->time = isset($request->time) ? $request->time : null;
            $leads->branchpin = isset($request->branchpin) ? $request->branchpin : null;
            $leads->parentid = isset($request->parentid) ? $request->parentid : null;
            $leads->branch_id = isset($branch->id) ? $branch->id : null;
            if ($leads->save()) {
                $id = $leads->id;
                $customer = new BeneficiaryImport();
                $customer->branch_id = isset($branch->id) ? $branch->id : null;
                $customer->customer_name = isset($request->name) ? $request->name : null;
                $customer->mobile_number = isset($request->mobile) ? $request->mobile : null;
                $customer->invoice_date = isset($request->date) ? $request->date : null;
                $customer->description = isset($request->category) ? $request->category : null;
                $customer->jd_lead_id = $id;
                $customer->source = BeneficiaryImport::SOURCE_TYPE_JUST_DIAL;
                $customer->save();
                $response->status = 'SUCCESS';

                $this->sendOnesignalJustDialNotification($leads);
            }
            DB::commit();
            return response()->json($response);
        } catch (\Exception $e) {
            DB::rollback();
            Log::info('addLeads just dial error : ' . $e->getMessage());
            return response()->json($response);
        }
    }

    function sendOnesignalJustDialNotification($leads)
    {
        $playerIds = User::select('users.player_id')
            ->join('branch_leads_assign', 'branch_leads_assign.user_id', 'users.id')
            ->where('users.status', User::STATUS_ACTIVE)
            ->where('branch_leads_assign.branch_id', $leads->branch_id)
            ->where('player_id', '!=', 'null')
            ->whereNotNull('users.player_id')
            ->pluck('player_id');
        if (count($playerIds) > 0) {
            $url = 'https://api.onesignal.com/notifications?c=push';
            $bodyParams = array(
                'app_id' => constants('ONE_SIGNAL_APP_ID'),
                'contents' => array('en' => 'You have received new lead from justdial...'),
                'headings' => array('en' => 'Justdial Lead Notification'),
                'include_player_ids' => $playerIds
            );
            $response = $this->commonService->coreGuzzlePostOneSignal($url, $bodyParams);
            Log::info('One signal response : ' . json_encode($response));
            if ($response->status == 200 && isset($response->data->id) && $response->data->id) {
                Log::info('One signal notification sent justdial');
            }
        }
    }
}
