<?php

namespace App\Services\Master;

use App\Models\Masters\AgentMapping;
use App\Models\Masters\ClusterMaster;
use App\Models\Masters\ClusterBranchMapping;
use App\Models\Masters\BranchMaster;
use App\Models\Masters\CityMaster;
use App\Models\Masters\DesignationMaster;
use App\Models\RoleMaster;
use App\Models\User;
use DB;
use Illuminate\Http\Request as HttpRequest;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;

class ClusterService
{

    public function __construct()
    {
    }

    public function getData()
    {
        
        $data = ClusterMaster::select('cluster_master.id', 'cluster_master.name', 'cluster_master.status', 'cluster_master.code', 'cluster_master.phone', 'branch_master.name as branch')
           ->join('branch_master', 'branch_master.id', 'cluster_master.branch')
           ->orderBy('cluster_master.id');
        return $data;
     }

    public function showData($id)
    {
        $data = DB::table('cluster_master')
            ->join('branch_master', 'branch_master.id', 'cluster_master.branch')
            ->where('cluster_master.id', $id)
            ->select('cluster_master.*', 'branch_master.name as branch')
            ->first();
            
        // Retrieve branches associated with the cluster from cluster_branch_mapping table
        $branches = DB::table('cluster_branch_mapping')
        ->join('branch_master', 'branch_master.id', '=', 'cluster_branch_mapping.branch_id')
        ->where('cluster_branch_mapping.cluster_id', $id)
        ->select('branch_master.name', 'branch_master.code')
        ->get();

        $data->branches = $branches;
        return $data;

    }

    public function isNew($id = null)
    {

        if ($id) {
            $id = decrypt($id);
            $data = ClusterMaster::find($id);
            $data->route = route('cluster-master.update', $id);
            $data->method = 'PUT';
            $data->breadcrumbName = 'Edit';
    
            // Get user id
            $userData = User::where('email', $data->phone)->first();
            $data->userId = $userData->id;
            $data->email = $userData->email;
    
            // Fetch the selected branches for the current cluster
            $data->selectedBranches = DB::table('cluster_branch_mapping')
                ->where('cluster_id', $id)
                ->pluck('branch_id')
                ->toArray();
    
        } else {
            $data = new ClusterMaster();
            $data->route = route('cluster-master.store');
            $data->method = 'POST';
            $data->breadcrumbName = 'Create';
    
            // Set selected branches as an empty array
            $data->selectedBranches = [];
        }
    
        // Get the list of all active branches
        $data->branches = BranchMaster::whereStatus(BranchMaster::STATUS_ACTIVE)->get();
        $data->branchList = BranchMaster::whereStatus(BranchMaster::STATUS_ACTIVE)->get();
        $data->breadcrumbAction = route('cluster-master.index');
        $data->breadcrumbTitle = 'Cluster';
        $data->designationList = DesignationMaster::whereStatus(DesignationMaster::STATUS_ACTIVE)->get();
    
        return $data;
    }
    
    public function saveData(HttpRequest $request, $id = null)
    {
        $name = $request->has('name') ? $request->get('name') : '';
        $code = $request->has('code') ? $request->get('code') : '';
        $phone = $request->has('phone') ? $request->get('phone') : '';
        $singleBranch = $request->has('single_branch') ? $request->get('single_branch') : '';
        $branch = $request->get('branch', []);
        $email = $request->has('email') ? $request->get('email') : '';
        $password = $request->has('password') ? $request->get('password') : '';
        $role = RoleMaster::ROLE_CLUSTER;
        $clusterId = $request->has('clusterId') ? $request->get('clusterId') : '';
        $userId = $request->has('userId') ? $request->get('userId') : '';

        // Handling the cluster data
        if ($clusterId) {
            $data = ClusterMaster::find($clusterId);
            $data->updated_by = Auth::user()->id;
            $user = User::find($userId);
        } else {
            $data = new ClusterMaster();
            $data->created_by = Auth::user()->id;
            $data->updated_by = Auth::user()->id;
            $user = new User();
            $user->password = Hash::make($password);
        }

        $data->name = $name;
        $data->code = $code;
        $data->phone = $phone;
        $data->branch = $singleBranch; // Store the single branch ID
        $data->role = $role;
        $data->save();
        $lastId = $data->id;

        // Save data to the user table
        if (!$clusterId) {
            $user->reference_id = $lastId;
        }

        $user->name = $name;
        $user->email = $email;
        $user->role = $role;
        $user->user_type = User::USER_TYPE_CLUSTER;
        $user->save();

        // Save branches to the cluster_branch_mapping table
        // Clear old mappings if updating
        if ($clusterId) {
            // Delete existing mappings for the given cluster using the model
            DB::table('cluster_branch_mapping')->where('cluster_id', $clusterId)->delete();
        }
        // Iterate through each branch and create new mappings
        foreach ($branch as $branchId) {
            $mapping = new ClusterBranchMapping();
            $mapping->cluster_id = $lastId;
            $mapping->branch_id = $branchId;
            $mapping->save();
        }
        
        return $data ? true : false;
    }
}

