<?php

namespace App\Services\Master;

use App\Models\Masters\DesignationMaster;
use App\Models\RoleMaster;
use Illuminate\Http\Request as HttpRequest;
use Illuminate\Support\Facades\Auth;

class DesignationService
{

    public function __construct()
    {

    }

    public function getData()
    {
        $data = DesignationMaster::orderBy('id');
        return $data;
    }

    public function isNew($id = null)
    {
        if ($id) {
            $id = decrypt($id);
            $data = DesignationMaster::find($id);
            $data->route = route('designation.update', $id);
            $data->method = 'PUT';
            $data->breadcrumbName = 'Edit';
        } else {
            $data = new DesignationMaster();
            $data->route = route('designation.store');
            $data->method = 'POST';
            $data->breadcrumbName = 'Create';
        }
        $data->breadcrumbAction = route('designation.index');
        $data->breadcrumbTitle = 'Designation';

        return $data;
    }

    public function saveData(HttpRequest $request, $id = null)
    {
        $name = $request->has('name') ? $request->get('name') : '';
        $designationId = $request->has('designationId') ? $request->get('designationId') : '';
        $callsPerUser = $request->has('callsPerUser') ? $request->get('callsPerUser') : '';

        if ($designationId) {
            $data = DesignationMaster::find($designationId);
            $data->updated_by = Auth::user()->id;
        } else {
            $data = new DesignationMaster();
            $data->created_by = Auth::user()->id;
            $data->updated_by = Auth::user()->id;
        }
        $data->name = $name;
        $data->calls_per_user = $callsPerUser;
        $data->save();

        if ($data) {
            return true;
        }
    }

}
